/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.OpenGLUtils;
import codechicken.lib.render.shader.Uniform;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.BooleanSupplier;

public interface ShaderObject {
    public String getName();

    public ShaderType getShaderType();

    public ImmutableList<Uniform> getUniforms();

    public boolean isDirty();

    public void alloc();

    public int getShaderID();

    public void onLink(int var1);

    public static enum StandardShaderType implements ShaderType
    {
        VERTEX(35633, () -> OpenGLUtils.openGL20),
        FRAGMENT(35632, () -> OpenGLUtils.openGL20),
        GEOMETRY(36313, () -> OpenGLUtils.openGL32),
        TESS_CONTROL(36488, () -> OpenGLUtils.openGL40),
        TESS_EVAL(36487, () -> OpenGLUtils.openGL40),
        COMPUTE(37305, () -> OpenGLUtils.openGL43);

        private final int glCode;
        private BooleanSupplier func;
        private boolean isSupported;

        private StandardShaderType(int glCode, BooleanSupplier func) {
            this.glCode = glCode;
            this.func = Objects.requireNonNull(func);
        }

        @Override
        public int getGLCode() {
            return this.glCode;
        }

        @Override
        public boolean isSupported() {
            if (this.func != null) {
                this.isSupported = this.func.getAsBoolean();
                this.func = null;
            }
            return this.isSupported;
        }
    }

    public static interface ShaderType {
        public int getGLCode();

        public boolean isSupported();
    }
}

