/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.vec.uv;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.IrreversibleTransformationException;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.apache.commons.lang3.tuple.Triple;

public class IconVertexRangeUVTransform
extends UVTransformation {
    private final ImmutableList<Triple<Integer, Integer, TextureAtlasSprite>> transformMap;

    private IconVertexRangeUVTransform(List<Triple<Integer, Integer, TextureAtlasSprite>> transformMap) {
        this.transformMap = ImmutableList.copyOf(transformMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void operate(CCRenderState ccrs) {
        UV uv = ccrs.vert.uv;
        int index = ccrs.vertexIndex;
        TextureAtlasSprite sprite = this.getSpriteForVertexIndex(index);
        if (sprite == null) {
            return;
        }
        uv.u = sprite.func_94214_a(uv.u * 16.0);
        uv.v = sprite.func_94207_b(uv.v * 16.0);
        ccrs.sprite = this.getSpriteForVertexIndex(ccrs.vertexIndex);
    }

    @Override
    public void apply(UV uv) {
    }

    @Override
    public UVTransformation inverse() {
        throw new IrreversibleTransformationException(this);
    }

    public TextureAtlasSprite getSpriteForVertexIndex(int index) {
        for (Triple entry : this.transformMap) {
            if (!MathHelper.between(((Integer)entry.getLeft()).intValue(), index, ((Integer)entry.getMiddle()).intValue())) continue;
            return (TextureAtlasSprite)entry.getRight();
        }
        return null;
    }

    public static class Builder {
        private LinkedList<Triple<Integer, Integer, TextureAtlasSprite>> transformMap = new LinkedList();

        private Builder() {
        }

        public IconVertexRangeUVTransform build() {
            return new IconVertexRangeUVTransform(this.transformMap);
        }

        public Builder addTransform(int start, int end, TextureAtlasSprite sprite) {
            for (Triple triple : this.transformMap) {
                if (!MathHelper.between(((Integer)triple.getLeft()).intValue(), start, ((Integer)triple.getMiddle()).intValue()) && !MathHelper.between(((Integer)triple.getLeft()).intValue(), end, ((Integer)triple.getMiddle()).intValue())) continue;
                throw new IllegalArgumentException("Unable to have overlapping sprite transforms!");
            }
            this.transformMap.add((Triple<Integer, Integer, TextureAtlasSprite>)Triple.of((Object)start, (Object)end, (Object)sprite));
            return this;
        }
    }
}

