/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import dev.quarris.ppfluids.PPFluids;
import dev.quarris.ppfluids.container.FluidExtractionModuleContainer;
import dev.quarris.ppfluids.container.FluidFilterModuleContainer;
import dev.quarris.ppfluids.container.FluidRetrievalModuleContainer;
import dev.quarris.ppfluids.items.FluidExtractionModuleItem;
import dev.quarris.ppfluids.items.FluidFilterModuleItem;
import dev.quarris.ppfluids.items.FluidItem;
import dev.quarris.ppfluids.items.FluidRetrievalModuleItem;
import dev.quarris.ppfluids.pipe.FluidPipeBlock;
import dev.quarris.ppfluids.pipe.FluidPipeTileEntity;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="ppfluids", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModContent {
    @ObjectHolder(value="ppfluids:fluid_pipe")
    public static Block FLUID_PIPE;
    @ObjectHolder(value="ppfluids:fluid_item")
    public static Item FLUID_ITEM;
    @ObjectHolder(value="ppfluids:fluid_pipe")
    public static TileEntityType<FluidPipeTileEntity> FLUID_PIPE_TILE;
    @ObjectHolder(value="ppfluids:fluid_filter")
    public static ContainerType<FluidFilterModuleContainer> FLUID_FILTER_CONTAINER;
    @ObjectHolder(value="ppfluids:fluid_extraction")
    public static ContainerType<FluidExtractionModuleContainer> FLUID_EXTRACTION_CONTAINER;
    @ObjectHolder(value="ppfluids:fluid_retrieval")
    public static ContainerType<FluidRetrievalModuleContainer> FLUID_RETRIEVAL_CONTAINER;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new FluidPipeBlock().setRegistryName("ppfluids", "fluid_pipe")});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockItem(FLUID_PIPE, new Item.Properties().func_200916_a(Registry.GROUP)).setRegistryName(FLUID_PIPE.getRegistryName()), (Item)new FluidItem().setRegistryName("ppfluids", "fluid_item")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModContent.createTieredModule("fluid_extraction_module", FluidExtractionModuleItem::new));
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModContent.createTieredModule("fluid_filter_module", FluidFilterModuleItem::new));
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModContent.createTieredModule("fluid_retrieval_module", FluidRetrievalModuleItem::new));
        IPipeItem.TYPES.put(FluidPipeItem.TYPE, FluidPipeItem::new);
    }

    @SubscribeEvent
    public static void registerTiles(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{(TileEntityType)TileEntityType.Builder.func_223042_a(FluidPipeTileEntity::new, (Block[])new Block[]{FLUID_PIPE}).func_206865_a(null).setRegistryName(FLUID_PIPE.getRegistryName())});
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{ModContent.createPipeContainer(PPFluids.createRes("fluid_filter")), ModContent.createPipeContainer(PPFluids.createRes("fluid_extraction")), ModContent.createPipeContainer(PPFluids.createRes("fluid_retrieval"))});
    }

    private static Item[] createTieredModule(String name, BiFunction<String, ModuleTier, ModuleItem> item) {
        Item[] items = new Item[ModuleTier.values().length];
        int i = 0;
        for (ModuleTier tier : ModuleTier.values()) {
            items[i] = (Item)item.apply(name, tier).setRegistryName("ppfluids", tier.name().toLowerCase(Locale.ROOT) + "_" + name);
            ++i;
        }
        return items;
    }

    private static <T extends AbstractPipeContainer<?>> ContainerType<T> createPipeContainer(ResourceLocation name) {
        return (ContainerType)IForgeContainerType.create((windowId, inv, data) -> {
            PipeTileEntity tile = (PipeTileEntity)Utility.getTileEntity(PipeTileEntity.class, (IBlockReader)inv.field_70458_d.field_70170_p, (BlockPos)data.func_179259_c());
            int moduleIndex = data.readInt();
            ItemStack moduleStack = tile.modules.getStackInSlot(moduleIndex);
            return ((IModule)moduleStack.func_77973_b()).getContainer(moduleStack, tile, windowId, inv, inv.field_70458_d, moduleIndex);
        }).setRegistryName(name);
    }
}

