/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class FluidBlobRenderer {
    private static final FluidBlobModel MODEL = new FluidBlobModel();

    public static void render(FluidPipeItem item, MatrixStack matrixStack, Random random, float partialTicks, int light, int overlay, IRenderTypeBuffer buffer) {
        FluidStack fluidStack = item.getFluidContent();
        Fluid fluid = fluidStack.getFluid();
        float size = MathHelper.func_219799_g((float)Math.min(1.0f, (float)fluidStack.getAmount() / 2000.0f), (float)0.1f, (float)0.25f);
        int color = fluid.getAttributes().getColor(fluidStack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        TextureAtlasSprite sprite = FluidBlobRenderer.getFluidStillSprite(fluid);
        IVertexBuilder vbuf = sprite.func_229230_a_(buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)sprite.func_229241_m_().func_229223_g_())));
        matrixStack.func_227861_a_((double)item.x, (double)item.y, (double)item.z);
        matrixStack.func_227862_a_(size, size, size);
        MODEL.func_225598_a_(matrixStack, vbuf, light, overlay, r, g, b, a);
    }

    private static TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getAttributes().getStillTexture());
    }

    public static class FluidBlobModel
    extends Model {
        private ModelRenderer blob = new ModelRenderer((Model)this);

        public FluidBlobModel() {
            super(RenderType::func_228638_b_);
            this.blob.func_78784_a(0, 0).func_228300_a_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f);
        }

        public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.blob.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

