/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.container;

import dev.quarris.ppfluids.misc.FluidFilter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FluidFilterSlot
extends SlotItemHandler {
    private final FluidFilter filter;
    private final int index;

    public FluidFilterSlot(FluidFilter filter, int index, int xPosition, int yPosition) {
        super((IItemHandler)filter, index, xPosition, yPosition);
        this.index = index;
        this.filter = filter;
    }

    public static boolean isFilterSlot(Container container, int slotId, PlayerEntity player) {
        Slot slot;
        if (slotId >= 0 && slotId < container.field_75151_b.size() && (slot = container.func_75139_a(slotId)) instanceof FluidFilterSlot) {
            ((FluidFilterSlot)slot).slotClick(player);
            return true;
        }
        return false;
    }

    private void slotClick(PlayerEntity player) {
        FluidStack fluid;
        ItemStack heldStack = player.field_71071_by.func_70445_o();
        ItemStack stackInSlot = this.func_75211_c();
        if (!stackInSlot.func_190926_b() && heldStack.func_190926_b()) {
            this.putFluidStack(FluidStack.EMPTY);
        } else if (!heldStack.func_190926_b() && !(fluid = FluidUtil.getFluidContained((ItemStack)heldStack).orElse(FluidStack.EMPTY).copy()).isEmpty()) {
            fluid.setAmount(1);
            this.putFluidStack(fluid);
        }
    }

    public void putFluidStack(FluidStack stack) {
        this.filter.setFilter(this.index, stack);
        this.func_75218_e();
    }

    public void func_75218_e() {
        this.filter.setModified(true);
    }

    public boolean func_75214_a(ItemStack stack) {
        return false;
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        return false;
    }
}

