/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.items;

import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import dev.quarris.ppfluids.ModContent;
import dev.quarris.ppfluids.container.FluidExtractionModuleContainer;
import dev.quarris.ppfluids.items.IFluidFilterProvider;
import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.pipe.FluidPipeTileEntity;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import dev.quarris.ppfluids.pipenetwork.PipeNetworkUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidExtractionModuleItem
extends ModuleItem
implements IFluidFilterProvider {
    private final int maxExtraction;
    private final int speed;
    private final boolean preventOversending;
    public final int filterSlots;

    public FluidExtractionModuleItem(String name, ModuleTier tier) {
        super(name);
        this.maxExtraction = (Integer)tier.forTier((Object)500, (Object)2000, (Object)8000);
        this.speed = (Integer)tier.forTier((Object)20, (Object)15, (Object)10);
        this.filterSlots = (Integer)tier.forTier((Object)2, (Object)4, (Object)8);
        this.preventOversending = (Boolean)tier.forTier((Object)false, (Object)false, (Object)true);
    }

    public void tick(ItemStack module, PipeTileEntity tile) {
        if (tile.func_145831_w().func_82737_E() % (long)this.speed != 0L) {
            return;
        }
        if (!tile.canWork()) {
            return;
        }
        if (!(tile instanceof FluidPipeTileEntity)) {
            return;
        }
        FluidPipeTileEntity fluidPipe = (FluidPipeTileEntity)tile;
        FluidFilter filter = new FluidFilter(this.filterSlots, module, fluidPipe);
        for (Direction dir : Direction.values()) {
            FluidStack remain;
            FluidStack fluid;
            IFluidHandler tank = fluidPipe.getAdjacentFluidHandler(dir);
            if (tank == null || (fluid = tank.drain(this.maxExtraction, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || !filter.isAllowed(fluid) || (remain = PipeNetworkUtil.routeFluid(fluidPipe.func_145831_w(), fluidPipe.func_174877_v(), fluidPipe.func_174877_v().func_177972_a(dir), fluid, FluidPipeItem::new, this.preventOversending)).getAmount() == fluid.getAmount()) continue;
            tank.drain(fluid.getAmount() - remain.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            return;
        }
    }

    public boolean isCompatible(ItemStack itemStack, PipeTileEntity pipeTileEntity, IModule iModule) {
        return !(iModule instanceof FluidExtractionModuleItem);
    }

    public boolean canNetworkSee(ItemStack module, PipeTileEntity tile) {
        return false;
    }

    public boolean canAcceptItem(ItemStack module, PipeTileEntity tile, ItemStack stack) {
        return false;
    }

    public boolean hasContainer(ItemStack module, PipeTileEntity tile) {
        return tile instanceof FluidPipeTileEntity;
    }

    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeTileEntity tile, int windowId, PlayerInventory inv, PlayerEntity player, int moduleIndex) {
        return new FluidExtractionModuleContainer(ModContent.FLUID_EXTRACTION_CONTAINER, windowId, player, tile.func_174877_v(), moduleIndex);
    }

    @Override
    public FluidFilter getFluidFilter(ItemStack module, FluidPipeTileEntity tile) {
        return new FluidFilter(this.filterSlots, module, tile);
    }
}

