/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.items;

import dev.quarris.ppfluids.ModContent;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class FluidItem
extends ItemFluidContainer {
    public FluidItem() {
        super(new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1), Integer.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("info.ppfluids.fluid_item.usage"));
        FluidStack fluidStack = FluidItem.getFluidCopyFromItem(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent(fluidStack.getTranslationKey()).func_240702_b_(": ").func_240702_b_(String.valueOf(fluidStack.getAmount())));
    }

    public static ItemStack createItemFromFluid(FluidStack fluid, boolean simulate) {
        ItemStack item = new ItemStack((IItemProvider)ModContent.FLUID_ITEM);
        int filled = FluidUtil.getFluidHandler((ItemStack)item).map(tank -> tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE)).orElse(0);
        if (!simulate) {
            fluid.grow(filled);
        }
        return item;
    }

    public static FluidStack getFluidCopyFromItem(ItemStack item) {
        return FluidUtil.getFluidHandler((ItemStack)item).map(handler -> handler.getFluidInTank(0).copy()).orElse(FluidStack.EMPTY);
    }

    public static ItemStack insertFluid(IFluidHandler handler, ItemStack fluidItem, boolean simulate) {
        FluidStack fluidStack = FluidItem.getFluidCopyFromItem(fluidItem);
        int filled = handler.fill(fluidStack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        fluidStack.shrink(filled);
        if (fluidStack.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return FluidItem.createItemFromFluid(fluidStack, false);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStack.Consumable(stack, this.capacity){

            public boolean canFillFluidType(FluidStack fluid) {
                return this.getFluid().isEmpty();
            }
        };
    }
}

