/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.items;

import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import dev.quarris.ppfluids.ModContent;
import dev.quarris.ppfluids.container.FluidRetrievalModuleContainer;
import dev.quarris.ppfluids.items.FluidItem;
import dev.quarris.ppfluids.items.IFluidFilterProvider;
import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.pipe.FluidPipeTileEntity;
import dev.quarris.ppfluids.pipenetwork.PipeNetworkUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidRetrievalModuleItem
extends ModuleItem
implements IFluidFilterProvider {
    private final int maxExtraction;
    private final int speed;
    private final boolean preventOversending;
    public final int filterSlots;

    public FluidRetrievalModuleItem(String name, ModuleTier tier) {
        super(name);
        this.maxExtraction = (Integer)tier.forTier((Object)1, (Object)8, (Object)16);
        this.speed = (Integer)tier.forTier((Object)40, (Object)20, (Object)10);
        this.filterSlots = (Integer)tier.forTier((Object)3, (Object)6, (Object)9);
        this.preventOversending = (Boolean)tier.forTier((Object)false, (Object)true, (Object)true);
    }

    public void tick(ItemStack module, PipeTileEntity tile) {
        if (tile instanceof FluidPipeTileEntity && tile.shouldWorkNow(this.speed) && tile.canWork()) {
            FluidPipeTileEntity pipe = (FluidPipeTileEntity)tile;
            PipeNetwork network = PipeNetwork.get((World)pipe.func_145831_w());
            block0: for (FluidFilter filter : pipe.getFluidFilters()) {
                for (int slot = 0; slot < filter.getSlots(); ++slot) {
                    FluidStack filtered = filter.getFilter(slot);
                    if (filtered.isEmpty()) continue;
                    FluidStack copy = filtered.copy();
                    copy.setAmount(this.maxExtraction);
                    Pair<BlockPos, ItemStack> dest = pipe.getAvailableDestination(copy, true, this.preventOversending);
                    if (dest == null) continue;
                    ItemStack toRequest = ((ItemStack)dest.getRight()).func_77946_l();
                    if (PipeNetworkUtil.requestFluid(pipe.func_145831_w(), pipe.func_174877_v(), (BlockPos)dest.getLeft(), FluidItem.getFluidCopyFromItem(toRequest)).isEmpty()) continue block0;
                }
            }
        }
    }

    public boolean canNetworkSee(ItemStack module, PipeTileEntity tile) {
        return false;
    }

    public boolean canAcceptItem(ItemStack module, PipeTileEntity tile, ItemStack stack) {
        return false;
    }

    public boolean isCompatible(ItemStack module, PipeTileEntity tile, IModule other) {
        return !(other instanceof FluidRetrievalModuleItem);
    }

    public boolean hasContainer(ItemStack module, PipeTileEntity tile) {
        return tile instanceof FluidPipeTileEntity;
    }

    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeTileEntity tile, int windowId, PlayerInventory inv, PlayerEntity player, int moduleIndex) {
        return new FluidRetrievalModuleContainer(ModContent.FLUID_RETRIEVAL_CONTAINER, windowId, player, tile.func_174877_v(), moduleIndex);
    }

    @Override
    public FluidFilter getFluidFilter(ItemStack module, FluidPipeTileEntity tile) {
        FluidFilter filter = new FluidFilter(this.filterSlots, module, tile);
        filter.canModifyWhitelist = false;
        filter.isWhitelist = true;
        return filter;
    }
}

