/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.quarris.ppfluids.ModContent;
import dev.quarris.ppfluids.container.FluidFilterSlot;
import dev.quarris.ppfluids.network.ButtonPacket;
import dev.quarris.ppfluids.pipe.FluidPipeTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class FluidFilter
extends ItemStackHandler
implements INBTSerializable<CompoundNBT> {
    protected FluidPipeTileEntity pipe;
    protected ItemStack moduleItem;
    protected NonNullList<FluidStack> filters;
    public boolean canPopulateFromTanks;
    public boolean isWhitelist;
    public boolean canModifyWhitelist = true;
    private boolean modified;

    public FluidFilter(int size, ItemStack moduleItem, FluidPipeTileEntity pipe) {
        super(size);
        this.filters = NonNullList.func_191197_a((int)size, (Object)FluidStack.EMPTY);
        this.pipe = pipe;
        this.moduleItem = moduleItem;
        if (moduleItem.func_77942_o() && moduleItem.func_77978_p().func_74764_b("filter")) {
            this.deserializeNBT(moduleItem.func_77978_p().func_74775_l("filter"));
        }
    }

    public boolean isAllowed(ItemStack stack) {
        if (stack.func_77973_b() == ModContent.FLUID_ITEM) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(this::isAllowed).orElse(false);
        }
        return false;
    }

    public boolean isAllowed(FluidStack stack) {
        return this.isFiltered(stack) == this.isWhitelist;
    }

    private boolean isFiltered(FluidStack stack) {
        for (FluidStack fluid : this.filters) {
            if (!fluid.isFluidEqual(stack)) continue;
            return true;
        }
        return false;
    }

    public void setFilter(int slot, FluidStack filter) {
        this.filters.set(slot, (Object)(filter == null ? FluidStack.EMPTY : filter));
        this.setStackInSlot(slot, filter == null ? ItemStack.field_190927_a : FluidUtil.getFilledBucket((FluidStack)filter));
        this.modified = true;
    }

    public FluidStack getFilter(int slot) {
        return (FluidStack)this.filters.get(slot);
    }

    public List<Slot> createContainerSlots(int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.size(); ++i) {
            slots.add((Slot)new FluidFilterSlot(this, i, x + i % 9 * 18, y + i / 9 * 18));
        }
        return slots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Widget> createScreenButtons(final Screen gui, int x, int y) {
        ArrayList<Widget> buttons = new ArrayList<Widget>();
        if (this.canModifyWhitelist) {
            Supplier<TranslationTextComponent> whitelistText = () -> new TranslationTextComponent("info.prettypipes." + (this.isWhitelist ? "whitelist" : "blacklist"));
            buttons.add((Widget)new Button(x, y, 70, 20, (ITextComponent)whitelistText.get(), button -> {
                ButtonPacket.sendAndExecute(this.pipe.func_174877_v(), ButtonPacket.ButtonResult.FILTER_CHANGE, 0);
                button.func_238482_a_((ITextComponent)whitelistText.get());
            }));
        }
        if (this.canPopulateFromTanks) {
            buttons.add((Widget)new Button(x + 72, y, 70, 20, (ITextComponent)new TranslationTextComponent("info.prettypipes.populate"), button -> ButtonPacket.sendAndExecute(this.pipe.func_174877_v(), ButtonPacket.ButtonResult.FILTER_CHANGE, 1)){

                public void func_230443_a_(MatrixStack matrix, int x, int y) {
                    gui.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("info.prettypipes.populate.description").func_240699_a_(TextFormatting.GRAY), x, y);
                }
            });
        }
        return buttons;
    }

    public void onButtonPacket(int id) {
        if (id == 0 && this.canModifyWhitelist) {
            this.isWhitelist = !this.isWhitelist;
            this.modified = true;
            this.save();
        } else if (id == 1 && this.canPopulateFromTanks) {
            for (Direction dir : Direction.values()) {
                IFluidHandler handler = this.pipe.getAdjacentFluidHandler(dir);
                if (handler == null) continue;
                block1: for (int i = 0; i < handler.getTanks(); ++i) {
                    FluidStack stack = handler.getFluidInTank(i);
                    if (stack.isEmpty() || this.isFiltered(stack)) continue;
                    FluidStack copy = stack.copy();
                    copy.setAmount(1);
                    for (int j = 0; j < this.size(); ++j) {
                        if (!this.getFilter(j).isEmpty()) continue;
                        this.setFilter(j, copy);
                        continue block1;
                    }
                }
            }
        }
    }

    public int size() {
        return this.filters.size();
    }

    public void save() {
        if (this.modified) {
            this.moduleItem.func_196082_o().func_218657_a("filter", (INBT)this.serializeNBT());
            this.modified = false;
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT fluidList = new ListNBT();
        for (FluidStack fluid : this.filters) {
            fluidList.add((Object)fluid.writeToNBT(new CompoundNBT()));
        }
        nbt.func_218657_a("fluids", (INBT)fluidList);
        if (this.canModifyWhitelist) {
            nbt.func_74757_a("whitelist", this.isWhitelist);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT fluidList = nbt.func_150295_c("fluids", 10);
        for (int i = 0; i < fluidList.size(); ++i) {
            CompoundNBT fluidNBT = fluidList.func_150305_b(i);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidNBT);
            this.filters.set(i, (Object)fluid);
            this.setStackInSlot(i, FluidUtil.getFilledBucket((FluidStack)fluid));
        }
        if (this.canModifyWhitelist) {
            this.isWhitelist = nbt.func_74767_n("whitelist");
        }
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public static interface IFluidFilteredContainer {
        public FluidFilter getFilter();
    }
}

