/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.network;

import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.util.TriConsumer;

public class ButtonPacket {
    private BlockPos pos;
    private ButtonResult result;
    private int[] data;

    public ButtonPacket(BlockPos pos, ButtonResult result, int ... data) {
        this.pos = pos;
        this.result = result;
        this.data = data;
    }

    private ButtonPacket() {
    }

    public static ButtonPacket decode(PacketBuffer buf) {
        ButtonPacket packet = new ButtonPacket();
        packet.pos = buf.func_179259_c();
        packet.result = ButtonResult.values()[buf.readByte()];
        packet.data = buf.func_186863_b();
        return packet;
    }

    public static void encode(ButtonPacket packet, PacketBuffer buf) {
        buf.func_179255_a(packet.pos);
        buf.writeByte(packet.result.ordinal());
        buf.func_186875_a(packet.data);
    }

    public static void handle(ButtonPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            message.result.action.accept((Object)message.pos, (Object)message.data, (Object)player);
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sendAndExecute(BlockPos pos, ButtonResult result, int ... data) {
        PacketHandler.sendToServer(new ButtonPacket(pos, result, data));
        result.action.accept((Object)pos, (Object)data, (Object)Minecraft.func_71410_x().field_71439_g);
    }

    public static enum ButtonResult {
        FILTER_CHANGE((TriConsumer<BlockPos, int[], PlayerEntity>)((TriConsumer)(pos, data, player) -> {
            FluidFilter.IFluidFilteredContainer container = (FluidFilter.IFluidFilteredContainer)player.field_71070_bA;
            FluidFilter filter = container.getFilter();
            filter.onButtonPacket(data[0]);
        }));

        public final TriConsumer<BlockPos, int[], PlayerEntity> action;

        private ButtonResult(TriConsumer<BlockPos, int[], PlayerEntity> action) {
            this.action = action;
        }
    }
}

