/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipe;

import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import dev.quarris.ppfluids.ModContent;
import dev.quarris.ppfluids.items.FluidItem;
import dev.quarris.ppfluids.items.IFluidFilterProvider;
import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidPipeTileEntity
extends PipeTileEntity {
    public FluidPipeTileEntity() {
        super(ModContent.FLUID_PIPE_TILE);
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(FluidStack fluid, boolean force, boolean preventOversending) {
        if (!this.canWork()) {
            return null;
        }
        if (!force && this.streamModules().anyMatch(m -> !((IModule)m.getRight()).canAcceptItem((ItemStack)m.getLeft(), (PipeTileEntity)this, FluidItem.createItemFromFluid(fluid, false)))) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            PipeNetwork network;
            int onTheWay;
            int amountFilled;
            IFluidHandler tank = this.getAdjacentFluidHandler(dir);
            if (tank == null || (amountFilled = tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            FluidStack toInsert = fluid.copy();
            toInsert.setAmount(amountFilled);
            int maxAmount = Integer.MAX_VALUE;
            if (maxAmount < toInsert.getAmount()) {
                toInsert.setAmount(maxAmount);
            }
            BlockPos tankPos = this.field_174879_c.func_177972_a(dir);
            if ((preventOversending || maxAmount < Integer.MAX_VALUE) && (onTheWay = (network = PipeNetwork.get((World)this.field_145850_b)).getPipeItemsOnTheWay(tankPos).filter(item -> item instanceof FluidPipeItem).map(item -> (FluidPipeItem)((Object)item)).filter(item -> toInsert.getFluid().func_207187_a(item.getFluidContent().getFluid())).mapToInt(item -> item.getFluidContent().getAmount()).sum()) > 0) {
                FluidStack copy = toInsert.copy();
                copy.setAmount(Integer.MAX_VALUE);
                int totalSpace = tank.fill(copy, IFluidHandler.FluidAction.SIMULATE);
                if (onTheWay + toInsert.getAmount() > totalSpace) {
                    toInsert.setAmount(totalSpace - onTheWay);
                }
            }
            if (toInsert.isEmpty()) continue;
            return Pair.of((Object)tankPos, (Object)FluidItem.createItemFromFluid(toInsert, false));
        }
        return null;
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(ItemStack stack, boolean force, boolean preventOversending) {
        return null;
    }

    public boolean isConnectedInventory(Direction dir) {
        return this.getAdjacentFluidHandler(dir) != null;
    }

    public IFluidHandler getAdjacentFluidHandler(Direction dir) {
        IFluidHandler handler;
        if (!this.isConnected(dir)) {
            return null;
        }
        BlockPos pos = this.field_174879_c.func_177972_a(dir);
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile != null && (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()).orElse(null)) != null) {
            return handler;
        }
        return null;
    }

    public IItemHandler getItemHandler(Direction dir) {
        IFluidHandler fluidHandler = this.getAdjacentFluidHandler(dir);
        if (fluidHandler != null) {
            // empty if block
        }
        return null;
    }

    public List<FluidFilter> getFluidFilters() {
        return this.streamModules().filter(p -> p.getRight() instanceof IFluidFilterProvider).map(p -> ((IFluidFilterProvider)p.getRight()).getFluidFilter((ItemStack)p.getLeft(), this)).collect(Collectors.toList());
    }
}

