/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipenetwork;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import dev.quarris.ppfluids.client.FluidBlobRenderer;
import dev.quarris.ppfluids.items.FluidItem;
import dev.quarris.ppfluids.pipe.FluidPipeTileEntity;
import dev.quarris.ppfluids.pipenetwork.PipeNetworkUtil;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidPipeItem
extends PipeItem {
    public static final ResourceLocation TYPE = new ResourceLocation("prettypipes", "pipe_fluid");

    public FluidPipeItem(ItemStack stack, float speed) {
        super(TYPE, stack, speed);
    }

    public FluidPipeItem(CompoundNBT nbt) {
        this(TYPE, nbt);
    }

    public FluidPipeItem(ResourceLocation type, CompoundNBT nbt) {
        super(type, nbt);
    }

    public FluidStack getFluidContent() {
        IFluidHandlerItem tank = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)this.stack).orElse(null);
        if (tank != null) {
            return tank.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    public void drop(World world, ItemStack stack) {
        super.drop(world, stack);
    }

    protected void onPathObstructed(PipeTileEntity currPipe, boolean tryReturn) {
        if (currPipe.func_145831_w().field_72995_K) {
            return;
        }
        PipeNetwork network = PipeNetwork.get((World)currPipe.func_145831_w());
        if (tryReturn) {
            if (!this.retryOnObstruction && network.routeItemToLocation(currPipe.func_174877_v(), this.destInventory, this.getStartPipe(), this.startInventory, this.stack, speed -> this)) {
                this.retryOnObstruction = true;
                return;
            }
            FluidStack remain = PipeNetworkUtil.routeFluid(currPipe.func_145831_w(), currPipe.func_174877_v(), this.destInventory, FluidItem.getFluidCopyFromItem(this.stack), (stack, speed) -> this, false);
            if (!remain.isEmpty()) {
                this.drop(currPipe.func_145831_w(), FluidItem.createItemFromFluid(remain, false));
            }
        } else {
            this.drop(currPipe.func_145831_w(), this.stack);
        }
    }

    protected ItemStack store(PipeTileEntity currPipe) {
        if (currPipe instanceof FluidPipeTileEntity) {
            FluidPipeTileEntity currFluidPipe = (FluidPipeTileEntity)currPipe;
            Direction dir = Utility.getDirectionFromOffset((BlockPos)this.getDestInventory(), (BlockPos)this.getDestPipe());
            IPipeConnectable connectable = currFluidPipe.getPipeConnectable(dir);
            if (connectable != null) {
                return connectable.insertItem(currFluidPipe.func_174877_v(), dir, this.stack, false);
            }
            IFluidHandler handler = currFluidPipe.getAdjacentFluidHandler(dir);
            if (handler == null) {
                return this.stack;
            }
            return FluidItem.insertFluid(handler, this.stack, false);
        }
        return super.store(currPipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PipeTileEntity tile, MatrixStack matrixStack, Random random, float partialTicks, int light, int overlay, IRenderTypeBuffer buffer) {
        FluidBlobRenderer.render(this, matrixStack, random, partialTicks, light, overlay, buffer);
    }
}

