/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipenetwork;

import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import dev.quarris.ppfluids.items.FluidItem;
import dev.quarris.ppfluids.pipe.FluidPipeTileEntity;
import dev.quarris.ppfluids.pipenetwork.FluidNetworkLocation;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PipeNetworkUtil {
    public static FluidStack routeFluid(World world, BlockPos inputPipePos, BlockPos inputTankPos, FluidStack fluid, BiFunction<ItemStack, Float, FluidPipeItem> itemSupplier, boolean preventOversending) {
        PipeNetwork network = PipeNetwork.get((World)world);
        if (!network.isNode(inputPipePos)) {
            return fluid;
        }
        if (!world.func_175667_e(inputPipePos)) {
            return fluid;
        }
        PipeTileEntity inputPipe = network.getPipe(inputPipePos);
        if (inputPipe == null) {
            return fluid;
        }
        network.startProfile("find_fluid_destination");
        List nodes = network.getOrderedNetworkNodes(inputPipePos).stream().filter(arg_0 -> ((World)world).func_175667_e(arg_0)).filter(pos -> world.func_175625_s(pos) instanceof FluidPipeTileEntity).collect(Collectors.toList());
        for (int i = 0; i < nodes.size(); ++i) {
            FluidPipeTileEntity pipe;
            Pair<BlockPos, ItemStack> dest;
            BlockPos pipePos = (BlockPos)nodes.get(inputPipe.getNextNode(nodes, i));
            if (!world.func_175667_e(pipePos) || (dest = (pipe = (FluidPipeTileEntity)network.getPipe(pipePos)).getAvailableDestination(fluid.copy(), false, preventOversending)) == null || ((BlockPos)dest.getLeft()).equals((Object)inputTankPos)) continue;
            Function<Float, IPipeItem> sup = speed -> (FluidPipeItem)((Object)((Object)itemSupplier.apply((ItemStack)dest.getRight(), (Float)speed)));
            if (!network.routeItemToLocation(inputPipePos, inputTankPos, pipe.func_174877_v(), (BlockPos)dest.getLeft(), (ItemStack)dest.getRight(), sup)) continue;
            FluidStack remain = fluid.copy();
            FluidStack routedFluid = FluidItem.getFluidCopyFromItem((ItemStack)dest.getRight());
            remain.shrink(routedFluid.getAmount());
            network.endProfile();
            return remain;
        }
        network.endProfile();
        return fluid;
    }

    public static FluidStack requestFluid(World world, BlockPos destPipe, BlockPos destInventory, FluidStack fluid) {
        PipeNetwork network = PipeNetwork.get((World)world);
        FluidStack remain = fluid.copy();
        for (FluidNetworkLocation location : PipeNetworkUtil.getOrderedNetworkFluids(world, destPipe)) {
            remain = PipeNetworkUtil.requestExistingFluid(world, location, destPipe, destInventory, null, remain);
            if (!remain.isEmpty()) continue;
            return remain;
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack requestExistingFluid(World world, FluidNetworkLocation location, BlockPos destPipe, BlockPos destInventory, NetworkLock ignoredLock, FluidStack fluid) {
        PipeNetwork network = PipeNetwork.get((World)world);
        if (location.getPos().equals((Object)destInventory)) {
            return fluid;
        }
        int amount = location.getFluidAmount(world, fluid);
        if (amount <= 0) {
            return fluid;
        }
        FluidStack remain = fluid.copy();
        if (remain.getAmount() < amount) {
            amount = remain.getAmount();
        }
        remain.shrink(amount);
        for (int slot : location.getFluidSlots(world, fluid)) {
            IFluidHandler handler = location.getFluidHandler(world);
            FluidStack stack = handler.getFluidInTank(slot).copy();
            FluidStack extracted = handler.drain(stack, IFluidHandler.FluidAction.SIMULATE);
            ItemStack fluidItem = FluidItem.createItemFromFluid(extracted, false);
            if (!network.routeItemToLocation(location.pipePos, location.getPos(), destPipe, destInventory, fluidItem, speed -> new FluidPipeItem(fluidItem, speed.floatValue()))) continue;
            handler.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
            if ((amount -= extracted.getAmount()) > 0) continue;
            break;
        }
        return remain;
    }

    public static List<FluidNetworkLocation> getOrderedNetworkFluids(World world, BlockPos node) {
        PipeNetwork network = PipeNetwork.get((World)world);
        if (!network.isNode(node)) {
            return Collections.emptyList();
        }
        network.startProfile("get_network_fluids");
        ArrayList<FluidNetworkLocation> info = new ArrayList<FluidNetworkLocation>();
        for (BlockPos dest : network.getOrderedNetworkNodes(node)) {
            PipeTileEntity pipe;
            if (!world.func_175667_e(dest) || !((pipe = network.getPipe(dest)) instanceof FluidPipeTileEntity) || !pipe.canNetworkSee()) continue;
            FluidPipeTileEntity fluidPipe = (FluidPipeTileEntity)pipe;
            for (Direction dir : Direction.values()) {
                FluidNetworkLocation location;
                IFluidHandler handler = fluidPipe.getAdjacentFluidHandler(dir);
                if (handler == null || info.stream().anyMatch(l -> handler.equals(l.getFluidHandler(world))) || (location = new FluidNetworkLocation(dest, dir)).isEmpty(world)) continue;
                info.add(location);
            }
        }
        network.endProfile();
        return info;
    }
}

