/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.SoundTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class BuildingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_9 = 0;
    public static final int MODE_9ROW = 1;
    public static final int MODE_25 = 2;
    public static final int MODE_25ROW = 3;
    public static final int MODE_SINGLE = 4;
    public static final int MODE_LAST = 4;
    public static final String[] DESCRIPTIONS = new String[]{"9 blocks", "9 blocks row", "25 blocks", "25 blocks row", "single"};
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"undo", stack -> this.countUndoStates((ItemStack)stack) > 0, stack -> Integer.toString(this.countUndoStates((ItemStack)stack))), TooltipBuilder.parameter((String)"mode", stack -> DESCRIPTIONS[this.getMode((ItemStack)stack)]), TooltipBuilder.parameter((String)"submode", stack -> this.getSubMode((ItemStack)stack) == 1, stack -> this.getSubMode((ItemStack)stack) == 1 ? "Rotated" : "")});
    public static final int[] amount = new int[]{9, 9, 25, 25, 1};

    public BuildingWand() {
        this.usageFactor(1.0f);
    }

    private int countUndoStates(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT compound = stack.func_77978_p();
            return (compound.func_74764_b("undo1") ? 1 : 0) + (compound.func_74764_b("undo2") ? 1 : 0);
        }
        return 0;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        super.func_77624_a(itemStack, world, list, flags);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), itemStack, list, flags);
        this.showModeKeyDescription(list, "switch mode");
        this.showSubModeKeyDescription(list, "change orientation");
    }

    @Override
    public void toggleMode(PlayerEntity player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 4) {
            mode = 0;
        }
        Tools.notify(player, (IFormattableTextComponent)new StringTextComponent("Switched to " + DESCRIPTIONS[mode] + " mode"));
        stack.func_196082_o().func_74768_a("mode", mode);
    }

    @Override
    public void toggleSubMode(PlayerEntity player, ItemStack stack) {
        int submode = this.getSubMode(stack);
        submode = submode == 1 ? 0 : 1;
        Tools.notify(player, (IFormattableTextComponent)new StringTextComponent("Switched orientation"));
        stack.func_196082_o().func_74768_a("submode", submode);
    }

    private int getMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("mode");
    }

    private int getSubMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("submode");
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        ItemStack wandStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                this.undoPlaceBlock(wandStack, player, world, pos);
            } else {
                this.placeBlock(wandStack, player, world, pos, side);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void placeBlock(ItemStack wandStack, PlayerEntity player, World world, BlockPos pos, Direction side) {
        if (!this.checkUsage(wandStack, player, 1.0f)) {
            return;
        }
        boolean notenough = false;
        BlockState blockState = world.func_180495_p(pos);
        Set<BlockPos> coordinates = this.findSuitableBlocks(wandStack, world, side, pos, blockState);
        HashSet<BlockPos> undo = new HashSet<BlockPos>();
        for (BlockPos coordinate : coordinates) {
            if (!this.checkUsage(wandStack, player, 1.0f)) break;
            BlockRayTraceResult result = new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.UP, coordinate, false);
            ItemStack pickBlock = blockState.getPickBlock((RayTraceResult)result, (IBlockReader)world, coordinate, player);
            ItemStack consumed = Tools.consumeInventoryItem(pickBlock, player.field_71071_by, player);
            if (!consumed.func_190926_b()) {
                SoundTools.playSound((World)world, (SoundEvent)blockState.func_215695_r().func_185844_d(), (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), (double)1.0, (double)1.0);
                BlockSnapshot blocksnapshot = BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)coordinate);
                Tools.placeStackAt(player, consumed, world, coordinate, null);
                if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                    blocksnapshot.restore(true, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        Tools.giveItem(player, consumed);
                    }
                }
                player.field_71070_bA.func_75142_b();
                this.registerUsage(wandStack, player, 1.0f);
                undo.add(coordinate);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
        this.registerUndo(wandStack, blockState, world, undo);
    }

    private void registerUndo(ItemStack stack, BlockState state, World world, Set<BlockPos> undo) {
        CompoundNBT undoTag = new CompoundNBT();
        undoTag.func_218657_a("block", (INBT)NBTUtil.func_190009_a((BlockState)state));
        undoTag.func_74778_a("dimension", world.func_234923_W_().func_240901_a_().toString());
        int[] undoX = new int[undo.size()];
        int[] undoY = new int[undo.size()];
        int[] undoZ = new int[undo.size()];
        int idx = 0;
        for (BlockPos coordinate : undo) {
            undoX[idx] = coordinate.func_177958_n();
            undoY[idx] = coordinate.func_177956_o();
            undoZ[idx] = coordinate.func_177952_p();
            ++idx;
        }
        undoTag.func_74783_a("x", undoX);
        undoTag.func_74783_a("y", undoY);
        undoTag.func_74783_a("z", undoZ);
        CompoundNBT wandTag = stack.func_196082_o();
        if (wandTag.func_74764_b("undo1")) {
            wandTag.func_218657_a("undo2", wandTag.func_74781_a("undo1"));
        }
        wandTag.func_218657_a("undo1", (INBT)undoTag);
    }

    private void undoPlaceBlock(ItemStack stack, PlayerEntity player, World world, BlockPos pos) {
        CompoundNBT wandTag = stack.func_196082_o();
        CompoundNBT undoTag1 = (CompoundNBT)wandTag.func_74781_a("undo1");
        CompoundNBT undoTag2 = (CompoundNBT)wandTag.func_74781_a("undo2");
        Set<BlockPos> undo1 = this.checkUndo(player, world, undoTag1);
        Set<BlockPos> undo2 = this.checkUndo(player, world, undoTag2);
        if (undo1 == null && undo2 == null) {
            Tools.error(player, "Nothing to undo!");
            return;
        }
        if (undo1 != null && undo1.contains(pos)) {
            this.performUndo(stack, player, world, pos, undoTag1, undo1);
            if (wandTag.func_74764_b("undo2")) {
                wandTag.func_218657_a("undo1", wandTag.func_74781_a("undo2"));
                wandTag.func_82580_o("undo2");
            } else {
                wandTag.func_82580_o("undo1");
            }
            return;
        }
        if (undo2 != null && undo2.contains(pos)) {
            this.performUndo(stack, player, world, pos, undoTag2, undo2);
            wandTag.func_82580_o("undo2");
            return;
        }
        Tools.error(player, "Select at least one block of the area you want to undo!");
    }

    private void performUndo(ItemStack stack, PlayerEntity player, World world, BlockPos pos, CompoundNBT undoTag, Set<BlockPos> undo) {
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)undoTag.func_74775_l("block"));
        int cnt = 0;
        for (BlockPos coordinate : undo) {
            BlockState testState = world.func_180495_p(coordinate);
            if (testState != state) continue;
            SoundTools.playSound((World)world, (SoundEvent)state.func_215695_r().func_185844_d(), (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), (double)1.0, (double)1.0);
            BlockSnapshot blocksnapshot = BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)coordinate);
            world.func_175656_a(coordinate, Blocks.field_150350_a.func_176223_P());
            if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                blocksnapshot.restore(true, false);
                continue;
            }
            ++cnt;
        }
        if (cnt > 0 && !player.field_71075_bZ.field_75098_d) {
            BlockRayTraceResult result = new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.UP, pos, false);
            ItemStack itemStack = state.getPickBlock((RayTraceResult)result, (IBlockReader)world, pos, player);
            itemStack.func_190920_e(cnt);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)itemStack);
            player.field_71070_bA.func_75142_b();
        }
    }

    private Set<BlockPos> checkUndo(PlayerEntity player, World world, CompoundNBT undoTag) {
        if (undoTag == null) {
            return null;
        }
        String dimension = undoTag.func_74779_i("dimension");
        RegistryKey dim = LevelTools.getId((ResourceLocation)new ResourceLocation(dimension));
        if (!Objects.equals(dim, world.func_234923_W_())) {
            Tools.error(player, "Select at least one block of the area you want to undo!");
            return null;
        }
        int[] undoX = undoTag.func_74759_k("x");
        int[] undoY = undoTag.func_74759_k("y");
        int[] undoZ = undoTag.func_74759_k("z");
        HashSet<BlockPos> undo = new HashSet<BlockPos>();
        for (int i = 0; i < undoX.length; ++i) {
            undo.add(new BlockPos(undoX[i], undoY[i], undoZ[i]));
        }
        return undo;
    }

    @Override
    public void renderOverlay(RenderWorldLastEvent evt, PlayerEntity player, ItemStack wand) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(mouseOver instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult btrace = (BlockRayTraceResult)mouseOver;
        if (btrace.func_216354_b() != null && btrace.func_216350_a() != null) {
            World world = player.func_130014_f_();
            BlockPos blockPos = btrace.func_216350_a();
            if (blockPos == null) {
                return;
            }
            BlockState blockState = world.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            if (block != null && blockState.func_185904_a() != Material.field_151579_a) {
                if (player.func_225608_bj_()) {
                    CompoundNBT wandTag = wand.func_196082_o();
                    CompoundNBT undoTag1 = (CompoundNBT)wandTag.func_74781_a("undo1");
                    CompoundNBT undoTag2 = (CompoundNBT)wandTag.func_74781_a("undo2");
                    Set<BlockPos> undo1 = this.checkUndo(player, world, undoTag1);
                    Set<BlockPos> undo2 = this.checkUndo(player, world, undoTag2);
                    if (undo1 == null && undo2 == null) {
                        return;
                    }
                    if (undo1 != null && undo1.contains(blockPos)) {
                        Set<BlockPos> coordinates = undo1;
                        BuildingWand.renderOutlines(evt, player, coordinates, 240, 30, 0);
                    } else if (undo2 != null && undo2.contains(blockPos)) {
                        Set<BlockPos> coordinates = undo2;
                        BuildingWand.renderOutlines(evt, player, coordinates, 240, 30, 0);
                    }
                } else {
                    Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, btrace.func_216354_b(), blockPos, blockState);
                    BuildingWand.renderOutlines(evt, player, coordinates, 50, 250, 180);
                }
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, Direction sideHit, BlockPos pos, BlockState state) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        todo.addLast(pos);
        this.findSuitableBlocks(world, coordinates, done, todo, sideHit, state, amount[this.getMode(stack)], this.getMode(stack) == 1 || this.getMode(stack) == 3, this.getSubMode(stack));
        return coordinates;
    }

    private void findSuitableBlocks(World world, Set<BlockPos> coordinates, Set<BlockPos> done, Deque<BlockPos> todo, Direction direction, BlockState state, int maxAmount, boolean rowMode, int rotated) {
        BlockPos offset;
        BlockPos base;
        Direction dirA = null;
        Direction dirB = null;
        if (rowMode) {
            base = todo.getFirst();
            offset = base.func_177972_a(direction);
            dirA = rotated == 1 ? this.dir2(direction) : this.dir1(direction);
            dirB = dirA.func_176734_d();
            if (!this.isSuitable(world, state, base.func_177972_a(dirA), offset.func_177972_a(dirA)) || !this.isSuitable(world, state, base.func_177972_a(dirB), offset.func_177972_a(dirB))) {
                dirA = rotated == 1 ? this.dir3(direction) : this.dir2(direction);
                dirB = dirA.func_176734_d();
                if (!this.isSuitable(world, state, base.func_177972_a(dirA), offset.func_177972_a(dirA)) || !this.isSuitable(world, state, base.func_177972_a(dirB), offset.func_177972_a(dirB))) {
                    dirA = rotated == 1 ? this.dir1(direction) : this.dir3(direction);
                    dirB = dirA.func_176734_d();
                }
            }
        }
        while (!todo.isEmpty() && coordinates.size() < maxAmount) {
            base = todo.pollFirst();
            if (done.contains(base)) continue;
            done.add(base);
            offset = base.func_177972_a(direction);
            if (!this.isSuitable(world, state, base, offset)) continue;
            coordinates.add(offset);
            if (rowMode) {
                todo.addLast(base.func_177972_a(dirA));
                todo.addLast(base.func_177972_a(dirB));
                continue;
            }
            todo.addLast(base.func_177972_a(this.dir1(direction)));
            todo.addLast(base.func_177972_a(this.dir1(direction).func_176734_d()));
            todo.addLast(base.func_177972_a(this.dir2(direction)));
            todo.addLast(base.func_177972_a(this.dir2(direction).func_176734_d()));
            todo.addLast(base.func_177972_a(this.dir1(direction)).func_177972_a(this.dir2(direction)));
            todo.addLast(base.func_177972_a(this.dir1(direction)).func_177972_a(this.dir2(direction).func_176734_d()));
            todo.addLast(base.func_177972_a(this.dir1(direction).func_176734_d()).func_177972_a(this.dir2(direction)));
            todo.addLast(base.func_177972_a(this.dir1(direction).func_176734_d()).func_177972_a(this.dir2(direction).func_176734_d()));
        }
    }

    private boolean isSuitable(World world, BlockState state, BlockPos base, BlockPos offset) {
        BlockState destState = world.func_180495_p(offset);
        BlockState baseState = world.func_180495_p(base);
        return baseState == state && destState.func_185904_a().func_76222_j();
    }

    private Direction dir1(Direction direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return Direction.EAST;
            }
            case NORTH: 
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: 
            case EAST: {
                return Direction.DOWN;
            }
        }
        return null;
    }

    private Direction dir2(Direction direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return Direction.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return Direction.DOWN;
            }
            case WEST: 
            case EAST: {
                return Direction.SOUTH;
            }
        }
        return null;
    }

    private Direction dir3(Direction direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return Direction.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: 
            case EAST: {
                return Direction.SOUTH;
            }
        }
        return null;
    }
}

