/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class MovingWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public MovingWand() {
        this.usageFactor(1.5f);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, list, flagIn);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, list, flagIn);
        list.add(this.getBlockDescription(stack));
    }

    private ITextComponent getBlockDescription(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (!this.hasBlock(compound)) {
            return new StringTextComponent("Wand is empty").func_240699_a_(TextFormatting.RED);
        }
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("block"));
        ITextComponent name = Tools.getBlockName(state.func_177230_c());
        return new StringTextComponent("Block: ").func_230529_a_(name).func_240699_a_(TextFormatting.GREEN);
    }

    private boolean hasBlock(CompoundNBT compound) {
        return compound != null && compound.func_74764_b("block");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        CompoundNBT compound;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && this.hasBlock(compound = stack.func_77978_p())) {
            int distance;
            Vector3d end;
            Vector3d lookVec = player.func_70040_Z();
            Vector3d start = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
            RayTraceContext context = new RayTraceContext(start, end = start.func_72441_c(lookVec.field_72450_a * (double)(distance = ((Integer)BuildingWandsConfiguration.placeDistance.get()).intValue()), lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null);
            BlockRayTraceResult position = world.func_217299_a(context);
            if (position == null) {
                this.place(stack, world, new BlockPos(end), null, player);
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        if (!world.field_72995_K) {
            CompoundNBT compound = stack.func_77978_p();
            if (this.hasBlock(compound)) {
                this.place(stack, world, pos, side, player);
            } else {
                this.pickup(stack, player, world, pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.SUCCESS;
    }

    private void place(ItemStack stack, World world, BlockPos pos, Direction side, PlayerEntity player) {
        BlockPos pp = side == null ? pos : pos.func_177972_a(side);
        BlockState old = world.func_180495_p(pp);
        if (!world.func_175623_d(pp) && !old.func_185904_a().func_76222_j()) {
            Tools.error(player, "Something is in the way!");
            return;
        }
        CompoundNBT tagCompound = stack.func_196082_o();
        BlockState blockState = NBTUtil.func_190008_d((CompoundNBT)tagCompound.func_74775_l("block"));
        BlockSnapshot blocksnapshot = BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pp);
        world.func_180501_a(pp, blockState, 3);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
            blocksnapshot.restore(true, false);
            return;
        }
        if (tagCompound.func_74764_b("tedata")) {
            CompoundNBT tc = (CompoundNBT)tagCompound.func_74781_a("tedata");
            tc.func_74768_a("x", pp.func_177958_n());
            tc.func_74768_a("y", pp.func_177956_o());
            tc.func_74768_a("z", pp.func_177952_p());
            TileEntity tileEntity = TileEntity.func_235657_b_((BlockState)blockState, (CompoundNBT)tc);
            if (tileEntity != null) {
                world.func_217349_x(pp).func_177426_a(pp, tileEntity);
                tileEntity.func_70296_d();
                world.func_184138_a(pp, blockState, blockState, 3);
            }
        }
        tagCompound.func_82580_o("block");
        tagCompound.func_82580_o("tedata");
        tagCompound.func_82580_o("meta");
        stack.func_77982_d(tagCompound);
    }

    private void pickup(ItemStack stack, PlayerEntity player, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        double cost = MovingWand.checkPickup(player, world, pos, state, (Double)BuildingWandsConfiguration.maxHardness.get());
        if (cost < 0.0) {
            return;
        }
        if (!this.checkUsage(stack, player, (float)cost)) {
            return;
        }
        CompoundNBT tagCompound = stack.func_196082_o();
        ItemStack s = state.func_177230_c().func_185473_a((IBlockReader)world, pos, state);
        ITextComponent name = s.func_190926_b() ? Tools.getBlockName(state.func_177230_c()) : s.func_200301_q();
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            tagCompound.func_218657_a("block", (INBT)NBTUtil.func_190009_a((BlockState)state));
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity != null) {
                CompoundNBT tc = new CompoundNBT();
                tileEntity.func_189515_b(tc);
                world.func_175713_t(pos);
                tc.func_82580_o("x");
                tc.func_82580_o("y");
                tc.func_82580_o("z");
                tagCompound.func_218657_a("tedata", (INBT)tc);
            }
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            Tools.notify(player, new StringTextComponent("You took: ").func_230529_a_(name));
            this.registerUsage(stack, player, (float)cost);
        }
    }
}

