/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import romelo333.notenoughwands.NotEnoughWands;
import romelo333.notenoughwands.keys.KeyBindings;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.wands.WandUsage;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.varia.ClientTools;
import romelo333.notenoughwands.varia.IEnergyItem;
import romelo333.notenoughwands.varia.ItemCapabilityProvider;
import romelo333.notenoughwands.varia.Tools;

public class GenericWand
extends Item
implements IEnergyItem {
    protected float usageFactor = 1.0f;

    public GenericWand() {
        super(new Item.Properties().func_200916_a(NotEnoughWands.setup.getTab()).setNoRepair().func_200917_a(1));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemCapabilityProvider(stack, this);
    }

    public static double checkPickup(PlayerEntity player, World world, BlockPos pos, BlockState state, double maxHardness) {
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (hardness < 0.0f || (double)hardness > maxHardness) {
            Tools.error(player, "This block is to hard to take!");
            return -1.0;
        }
        if (!state.canEntityDestroy((IBlockReader)world, pos, (Entity)player)) {
            Tools.error(player, "You are not allowed to take this block!");
            return -1.0;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot take it!");
            return -1.0;
        }
        double cost = BuildingWandsConfiguration.getBlockCost(state);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to take this block");
            return -1.0;
        }
        return cost;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.needsPower()) {
            tooltip.add((ITextComponent)new StringTextComponent("Energy: " + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack)).func_240699_a_(TextFormatting.GREEN));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (this.needsPower() && ((Boolean)WandsConfiguration.showDurabilityBarForRF.get()).booleanValue()) {
            return true;
        }
        return super.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (this.needsPower() && ((Boolean)WandsConfiguration.showDurabilityBarForRF.get()).booleanValue()) {
            int max = this.getMaxEnergyStored(stack);
            return (double)(max - this.getEnergyStored(stack)) / (double)max;
        }
        return super.getDurabilityForDisplay(stack);
    }

    public GenericWand usageFactor(float usageFactor) {
        this.usageFactor = usageFactor;
        return this;
    }

    protected boolean checkUsage(ItemStack wandStack, PlayerEntity player, float difficultyScale) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (this.needsXP()) {
            int needsxp = this.calculateXP();
            int experience = Tools.getPlayerXP(player) - (int)((float)needsxp * difficultyScale);
            if (experience <= 0) {
                Tools.error(player, "Not enough experience!");
                return false;
            }
        }
        if (this.needsDamage() && wandStack.func_77952_i() >= wandStack.func_77958_k()) {
            Tools.error(player, "This wand can no longer be used!");
            return false;
        }
        if (this.needsPower()) {
            int needsrf = this.calculatePower();
            if (this.getEnergyStored(wandStack) < (int)((float)needsrf * difficultyScale)) {
                Tools.error(player, "Not enough energy to use this wand!");
                return false;
            }
        }
        return true;
    }

    public boolean func_77645_m() {
        return this.needsDamage();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.calculateMaxDamage();
    }

    protected void registerUsage(ItemStack stack, PlayerEntity player, float difficultyScale) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.needsXP()) {
            Tools.addPlayerXP(player, -((int)((float)this.calculateXP() * difficultyScale)));
        }
        if (this.needsDamage()) {
            stack.func_222118_a(1, (LivingEntity)player, playerEntity -> {});
        }
        if (this.needsPower()) {
            this.extractEnergy(stack, (int)((float)this.calculatePower() * difficultyScale), false);
        }
    }

    public void toggleMode(PlayerEntity player, ItemStack stack) {
    }

    public void toggleSubMode(PlayerEntity player, ItemStack stack) {
    }

    public void renderOverlay(RenderWorldLastEvent evt, PlayerEntity player, ItemStack wand) {
    }

    protected static void renderOutlines(RenderWorldLastEvent evt, PlayerEntity p, Set<BlockPos> coordinates, int r, int g, int b) {
        MatrixStack matrixStack = evt.getMatrixStack();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        ClientTools.renderOutlines(matrixStack, buffer, coordinates, r, g, b);
    }

    protected void showModeKeyDescription(List<ITextComponent> list, String suffix) {
        String keyDescription = KeyBindings.wandModifier != null ? KeyBindings.wandModifier.func_151464_g() : "unknown";
        list.add((ITextComponent)new StringTextComponent("Mode key (" + keyDescription + ") to " + suffix).func_240699_a_(TextFormatting.YELLOW));
    }

    protected void showSubModeKeyDescription(List<ITextComponent> list, String suffix) {
        String keyDescription = KeyBindings.wandSubMode != null ? KeyBindings.wandSubMode.func_151464_g() : "unknown";
        list.add((ITextComponent)new StringTextComponent("Sub-mode key (" + keyDescription + ") to " + suffix).func_240699_a_(TextFormatting.YELLOW));
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!this.needsPower()) {
            return 0;
        }
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.calculatePower(), maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!this.needsPower()) {
            return 0;
        }
        container.func_196082_o();
        int energy = container.func_77978_p().func_74762_e("Energy");
        int maxrf = this.calculateMaxPower();
        int energyReceived = Math.min(maxrf - energy, Math.min(maxrf, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.calculateMaxPower();
    }

    private int calculatePower() {
        return (int)(500.0f * this.usageFactor);
    }

    private int calculateMaxPower() {
        return (int)(100000.0f * this.usageFactor);
    }

    private int calculateMaxDamage() {
        return (int)(200.0f / this.usageFactor);
    }

    private int calculateXP() {
        return (int)(10.0f * this.usageFactor);
    }

    private boolean needsPower() {
        return ((WandUsage)((Object)WandsConfiguration.wandUsage.get())).needsPower();
    }

    private boolean needsDamage() {
        return WandsConfiguration.wandUsage.get() == WandUsage.DURABILITY;
    }

    private boolean needsXP() {
        return WandsConfiguration.wandUsage.get() == WandUsage.XP;
    }
}

