/*
 * Decompiled with CFR 0.152.
 */
package jeresources.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import jeresources.JEResources;
import jeresources.config.ConfigValues;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    public static Config instance = new Config();
    public static final ForgeConfigSpec COMMON = ConfigValues.build();

    private Config() {
    }

    public void loadConfig(ForgeConfigSpec spec, Path path) {
        JEResources.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        JEResources.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        JEResources.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
        ConfigValues.pushChanges();
    }

    @SubscribeEvent
    public void onLoad(ModConfig.Loading configEvent) {
        JEResources.LOGGER.debug("Loaded {} config file {}", (Object)"jeresources", (Object)configEvent.getConfig().getFileName());
        ConfigValues.pushChanges();
    }

    @SubscribeEvent
    public void onFileChange(ModConfig.Reloading configEvent) {
        JEResources.LOGGER.debug("Reloaded {} config file {}", (Object)"jeresources", (Object)configEvent.getConfig().getFileName());
        ConfigValues.pushChanges();
    }
}

