/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TransferState;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TesseractTile
extends BaseTileEntity {
    private TesseractReference reference;
    private final EnumMap<EnumChannelType, Integer> channels = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, TransferState> transferState = new EnumMap(EnumChannelType.class);
    private RedstoneState redstoneState = RedstoneState.DISABLED;
    private boolean redstone;
    private final Map<Direction, Map<Capability<?>, Object>> capabilities = new HashMap();

    public TesseractTile() {
        super(Tesseract.tesseract_tile);
        for (EnumChannelType enumChannelType : EnumChannelType.values()) {
            this.channels.put(enumChannelType, -1);
            this.transferState.put(enumChannelType, TransferState.BOTH);
        }
        for (EnumChannelType enumChannelType : Direction.values()) {
            this.capabilities.put((Direction)enumChannelType, new HashMap());
        }
    }

    public void setChannel(EnumChannelType type, int channel) {
        Channel newChannel;
        if (channel == this.channels.get((Object)type)) {
            return;
        }
        Channel oldChannel = this.getChannel(type);
        this.channels.put(type, channel);
        if (oldChannel != null) {
            oldChannel.removeTesseract(this.reference);
        }
        if ((newChannel = this.getChannel(type)) != null) {
            newChannel.addTesseract(this.reference);
        }
        this.updateReference();
        this.dataChanged();
    }

    public boolean renderOn() {
        return this.redstoneState == RedstoneState.DISABLED || this.redstoneState == (this.redstone ? RedstoneState.HIGH : RedstoneState.LOW);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.getChannel(EnumChannelType.ITEMS) == null) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> this.getChannel(EnumChannelType.ITEMS).getItemHandler(this)).cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.getChannel(EnumChannelType.FLUID) == null) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> this.getChannel(EnumChannelType.FLUID).getFluidHandler(this)).cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.getChannel(EnumChannelType.ENERGY) == null) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> this.getChannel(EnumChannelType.ENERGY).getEnergyStorage(this)).cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public <T> List<T> getSurroundingCapabilities(Capability<T> capability) {
        if (this.field_145850_b == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Direction facing : Direction.values()) {
            if (!this.capabilities.get(facing).containsKey(capability)) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || tile instanceof TesseractTile) continue;
                tile.getCapability(capability, facing.func_176734_d()).ifPresent(object -> {
                    this.capabilities.get(facing).put(capability, object);
                    list.add(object);
                });
                continue;
            }
            list.add(this.capabilities.get(facing).get(capability));
        }
        return list;
    }

    public boolean canSend(EnumChannelType type) {
        return this.transferState.get((Object)type).canSend() && this.redstoneState == RedstoneState.DISABLED || this.redstoneState == (this.redstone ? RedstoneState.HIGH : RedstoneState.LOW);
    }

    public boolean canReceive(EnumChannelType type) {
        return this.transferState.get((Object)type).canReceive() && this.redstoneState == RedstoneState.DISABLED || this.redstoneState == (this.redstone ? RedstoneState.HIGH : RedstoneState.LOW);
    }

    public int getChannelId(EnumChannelType type) {
        return this.channels.get((Object)type);
    }

    public TransferState getTransferState(EnumChannelType type) {
        return this.transferState.get((Object)type);
    }

    public void cycleTransferState(EnumChannelType type) {
        TransferState transferState = this.transferState.get((Object)type);
        this.transferState.put(type, transferState == TransferState.BOTH ? TransferState.SEND : (transferState == TransferState.SEND ? TransferState.RECEIVE : TransferState.BOTH));
        this.updateReference();
        this.dataChanged();
    }

    public RedstoneState getRedstoneState() {
        return this.redstoneState;
    }

    public void cycleRedstoneState() {
        this.redstoneState = this.redstoneState == RedstoneState.DISABLED ? RedstoneState.HIGH : (this.redstoneState == RedstoneState.HIGH ? RedstoneState.LOW : RedstoneState.DISABLED);
        this.updateReference();
        this.dataChanged();
    }

    public void setPowered(boolean powered) {
        if (this.redstone != powered) {
            this.redstone = powered;
            this.updateReference();
            this.dataChanged();
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.reference = TesseractTracker.SERVER.add(this);
        }
    }

    protected CompoundNBT writeData() {
        CompoundNBT compound = new CompoundNBT();
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.func_74768_a(type.name(), this.channels.get((Object)type).intValue());
            compound.func_74778_a("transferState" + type.name(), this.transferState.get((Object)type).name());
        }
        compound.func_74778_a("redstoneState", this.redstoneState.name());
        compound.func_74757_a("powered", this.redstone);
        return compound;
    }

    protected void readData(CompoundNBT compound) {
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, compound.func_74762_e(type.name()));
            if (!compound.func_74764_b("transferState" + type.name())) continue;
            this.transferState.put(type, TransferState.valueOf(compound.func_74779_i("transferState" + type.name())));
        }
        if (compound.func_74764_b("redstoneState")) {
            this.redstoneState = RedstoneState.valueOf(compound.func_74779_i("redstoneState"));
        }
        if (compound.func_74764_b("powered")) {
            this.redstone = compound.func_74767_n("powered");
        }
    }

    private Channel getChannel(EnumChannelType type) {
        if (this.channels.get((Object)type) < 0 || this.field_145850_b == null) {
            return null;
        }
        Channel channel = TesseractChannelManager.getInstance(this.field_145850_b).getChannelById(type, this.channels.get((Object)type));
        if (channel == null && !this.field_145850_b.field_72995_K) {
            this.channels.put(type, -1);
            this.updateReference();
            this.dataChanged();
        }
        return channel;
    }

    public void onNeighborChanged(BlockPos neighbor) {
        Direction facing = Direction.func_176737_a((float)(neighbor.func_177958_n() - this.field_174879_c.func_177958_n()), (float)(neighbor.func_177956_o() - this.field_174879_c.func_177956_o()), (float)(neighbor.func_177952_p() - this.field_174879_c.func_177952_p()));
        this.capabilities.get(facing).clear();
    }

    public void dataChanged() {
        super.dataChanged();
        this.field_145850_b.func_230547_a_(this.field_174879_c, this.func_195044_w().func_177230_c());
    }

    private void updateReference() {
        if (this.reference != null) {
            this.reference.update(this);
        }
    }

    public void onReplaced() {
        if (this.field_145850_b.field_72995_K) {
            for (EnumChannelType type : EnumChannelType.values()) {
                Channel channel = this.getChannel(type);
                if (channel == null) continue;
                channel.removeTesseract(this.reference);
            }
            TesseractTracker.SERVER.remove(this.field_145850_b, this.field_174879_c);
        }
    }
}

