/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.tesseract.TesseractTile;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.vector.Matrix4f;

public class TesseractTileRenderer
extends TileEntityRenderer<TesseractTile> {
    private static final Random RANDOM = new Random(31100L);
    private static final List<RenderType> RENDER_TYPES = (List)IntStream.range(0, 16).mapToObj(p_228882_0_ -> RenderType.func_228630_a_((int)(p_228882_0_ + 1))).collect(ImmutableList.toImmutableList());

    public TesseractTileRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TesseractTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (!tile.renderOn()) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227862_a_(0.65f, 0.65f, 0.65f);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        RANDOM.setSeed(31100L);
        int i = 15;
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        this.renderCube(0.15f, matrix4f, buffer.getBuffer(RENDER_TYPES.get(0)));
        for (int j = 1; j < i; ++j) {
            this.renderCube(2.0f / (float)(18 - j), matrix4f, buffer.getBuffer(RENDER_TYPES.get(j)));
        }
        matrixStack.func_227865_b_();
    }

    private void renderCube(float p_228883_3_, Matrix4f matrix4f, IVertexBuilder builder) {
        float f = (RANDOM.nextFloat() * 0.5f + 0.1f) * p_228883_3_;
        float f1 = (RANDOM.nextFloat() * 0.5f + 0.4f) * p_228883_3_;
        float f2 = (RANDOM.nextFloat() * 0.5f + 0.5f) * p_228883_3_;
        this.renderFace(matrix4f, builder, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, f, f1, f2);
        this.renderFace(matrix4f, builder, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f, f1, f2);
        this.renderFace(matrix4f, builder, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, f, f1, f2);
        this.renderFace(matrix4f, builder, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, f, f1, f2);
        this.renderFace(matrix4f, builder, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f, f1, f2);
        this.renderFace(matrix4f, builder, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, f, f1, f2);
    }

    private void renderFace(Matrix4f matrix4f, IVertexBuilder builder, float x1, float x2, float y1, float y2, float p_228884_8_, float p_228884_9_, float p_228884_10_, float p_228884_11_, float red, float green, float blue) {
        builder.func_227888_a_(matrix4f, x1, y1, p_228884_8_).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x2, y1, p_228884_9_).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x2, y2, p_228884_10_).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x1, y2, p_228884_11_).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
    }
}

