/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CombinedEnergyStorage
implements IEnergyStorage {
    private final Channel channel;
    private final TesseractTile requester;

    public CombinedEnergyStorage(Channel channel, TesseractTile requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.requester.canSend(EnumChannelType.ENERGY) || maxReceive <= 0) {
            return 0;
        }
        int amount = maxReceive;
        block0: for (TesseractReference location : this.channel.receivingTesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : tile.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                if (!storage.canReceive()) continue;
                int amount2 = storage.receiveEnergy(amount, simulate);
                if (amount2 > 0) {
                    amount -= amount2;
                }
                if (amount > 0) continue;
                break block0;
            }
        }
        return maxReceive - amount;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.requester.canReceive(EnumChannelType.ENERGY) || maxExtract <= 0) {
            return 0;
        }
        int amount = maxExtract;
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : tile.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                if (!storage.canExtract()) continue;
                int amount2 = storage.extractEnergy(amount, simulate);
                if (amount2 > 0) {
                    amount -= amount2;
                }
                if (amount > 0) continue;
                break block0;
            }
        }
        return maxExtract - amount;
    }

    public int getEnergyStored() {
        int amount = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : tile.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                amount += storage.getEnergyStored();
            }
        }
        return amount;
    }

    public int getMaxEnergyStored() {
        int amount = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : tile.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                amount += storage.getMaxEnergyStored();
            }
        }
        return amount;
    }

    public boolean canExtract() {
        return this.requester.canReceive(EnumChannelType.ENERGY);
    }

    public boolean canReceive() {
        return this.requester.canSend(EnumChannelType.ENERGY);
    }
}

