/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CombinedItemHandler
implements IItemHandler {
    private final Channel channel;
    private final TesseractTile requester;

    public CombinedItemHandler(Channel channel, TesseractTile requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public int getSlots() {
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                slots += handler.getSlots();
            }
        }
        return slots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    return handler.getStackInSlot(slot - slots);
                }
                slots += handler.getSlots();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.requester.canSend(EnumChannelType.ITEMS) || stack.func_190926_b()) {
            return stack;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    return reference.canReceive(EnumChannelType.ITEMS) ? handler.insertItem(slot - slots, stack, simulate) : stack;
                }
                slots += handler.getSlots();
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.requester.canReceive(EnumChannelType.ITEMS) || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    return reference.canSend(EnumChannelType.ITEMS) ? handler.extractItem(slot - slots, amount, simulate) : ItemStack.field_190927_a;
                }
                slots += handler.getSlots();
            }
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    return handler.getSlotLimit(slot - slots);
                }
                slots += handler.getSlots();
            }
        }
        return 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    return handler.isItemValid(slot - slots, stack);
                }
                slots += handler.getSlots();
            }
        }
        return false;
    }
}

