/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.ChannelList;
import com.supermartijn642.tesseract.packets.PacketAddChannel;
import com.supermartijn642.tesseract.packets.PacketCompleteChannelsUpdate;
import com.supermartijn642.tesseract.packets.PacketRemoveChannel;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TesseractChannelManager {
    public static MinecraftServer minecraftServer;
    private static File directory;
    public static final TesseractChannelManager SERVER;
    public static final TesseractChannelManager CLIENT;
    private final HashMap<EnumChannelType, ChannelList> types = new HashMap();

    public static TesseractChannelManager getInstance(World world) {
        return world.field_72995_K ? CLIENT : SERVER;
    }

    public Channel addChannel(EnumChannelType type, UUID creator, boolean isPrivate, String name) {
        this.types.putIfAbsent(type, new ChannelList(type));
        Channel channel = this.types.get((Object)type).add(creator, isPrivate, name);
        this.sendAddChannelPacket(channel);
        return channel;
    }

    public Channel addChannel(Channel channel) {
        this.types.putIfAbsent(channel.type, new ChannelList(channel.type));
        this.types.get((Object)channel.type).add(channel);
        this.sendAddChannelPacket(channel);
        return channel;
    }

    public void removeChannel(EnumChannelType type, int id) {
        this.types.putIfAbsent(type, new ChannelList(type));
        this.types.get((Object)type).remove(id);
        this.sendRemoveChannelPacket(type, id);
    }

    public void sortChannels(PlayerEntity player, EnumChannelType type) {
        if (player == null || player.field_70170_p == null || !player.field_70170_p.field_72995_K) {
            return;
        }
        this.types.putIfAbsent(type, new ChannelList(type));
        this.types.get((Object)type).sortForPlayer(player);
    }

    public List<Channel> getChannels(EnumChannelType type) {
        this.types.putIfAbsent(type, new ChannelList(type));
        return this.types.get((Object)type).getChannels();
    }

    public List<Channel> getChannelsCreatedBy(EnumChannelType type, UUID creator) {
        this.types.putIfAbsent(type, new ChannelList(type));
        return this.types.get((Object)type).getChannelsCreatedBy(creator);
    }

    public Channel getChannelById(EnumChannelType type, int id) {
        this.types.putIfAbsent(type, new ChannelList(type));
        return this.types.get((Object)type).getById(id);
    }

    public void clear() {
        for (EnumChannelType type : EnumChannelType.values()) {
            this.types.putIfAbsent(type, new ChannelList(type));
            this.types.get((Object)type).clear();
        }
    }

    public void sendCompleteUpdatePacket(PlayerEntity player) {
        if (this == SERVER) {
            Tesseract.CHANNEL.sendToPlayer(player, (BasePacket)new PacketCompleteChannelsUpdate(true));
        }
    }

    public void sendAddChannelPacket(Channel channel) {
        if (this == SERVER) {
            Tesseract.CHANNEL.sendToAllPlayers((BasePacket)new PacketAddChannel(channel));
        }
    }

    public void sendRemoveChannelPacket(EnumChannelType type, int id) {
        if (this == SERVER) {
            Tesseract.CHANNEL.sendToAllPlayers((BasePacket)new PacketRemoveChannel(type, id));
        }
    }

    @SubscribeEvent
    public static void onSave(WorldEvent.Save e) {
        if (e.getWorld().func_201670_d() || !(e.getWorld() instanceof World) || ((World)e.getWorld()).func_234923_W_() != World.field_234918_g_) {
            return;
        }
        for (ChannelList list : TesseractChannelManager.SERVER.types.values()) {
            File folder = new File(directory, list.type.name().toLowerCase(Locale.ENGLISH));
            if (!folder.exists()) {
                folder.mkdirs();
            }
            list.write(folder);
        }
    }

    @SubscribeEvent
    public static void onLoad(WorldEvent.Load e) {
        if (e.getWorld().func_201670_d() || !(e.getWorld() instanceof World) || ((World)e.getWorld()).func_234923_W_() != World.field_234918_g_) {
            return;
        }
        minecraftServer = ((ServerWorld)e.getWorld()).func_73046_m();
        directory = new File(((ServerWorld)e.getWorld()).func_73046_m().func_240776_a_(FolderName.field_237253_i_).toFile(), "tesseract");
        for (EnumChannelType type : EnumChannelType.values()) {
            ChannelList list = new ChannelList(type);
            TesseractChannelManager.SERVER.types.put(type, list);
            File folder = new File(directory, type.name().toLowerCase(Locale.ENGLISH));
            list.read(folder);
        }
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!e.getPlayer().func_130014_f_().field_72995_K) {
            SERVER.sendCompleteUpdatePacket(e.getPlayer());
        }
    }

    static {
        SERVER = new TesseractChannelManager();
        CLIENT = new TesseractChannelManager();
    }
}

