/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractReference;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TesseractTracker {
    public static MinecraftServer minecraftServer;
    public static final TesseractTracker SERVER;
    private final HashMap<String, HashMap<BlockPos, TesseractReference>> tesseracts = new HashMap();
    private final Set<TesseractReference> toBeRemoved = new HashSet<TesseractReference>();

    public static TesseractTracker getInstance(World world) {
        return world.field_72995_K ? null : SERVER;
    }

    public TesseractReference add(TesseractTile self) {
        String dimension = self.func_145831_w().func_234923_W_().func_240901_a_().toString();
        this.tesseracts.putIfAbsent(dimension, new HashMap());
        return this.tesseracts.get(dimension).computeIfAbsent(self.func_174877_v(), key -> new TesseractReference(self));
    }

    @Deprecated
    public TesseractReference tryAdd(String dimension, BlockPos pos) {
        if (minecraftServer == null) {
            return null;
        }
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimension));
        ServerWorld world = TesseractChannelManager.minecraftServer.func_71218_a(key);
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TesseractTile ? this.add((TesseractTile)tile) : null;
    }

    public void remove(World world, BlockPos pos) {
        String dimension = world.func_234923_W_().func_240901_a_().toString();
        this.remove(dimension, pos);
    }

    public void remove(String dimension, BlockPos pos) {
        this.tesseracts.putIfAbsent(dimension, new HashMap());
        TesseractReference reference = this.tesseracts.get(dimension).get(pos);
        if (reference != null) {
            this.toBeRemoved.add(reference);
        }
    }

    private void removeAndUpdate(TesseractReference reference) {
        reference.delete();
        this.tesseracts.putIfAbsent(reference.getDimension(), new HashMap());
        this.tesseracts.get(reference.getDimension()).remove(reference.getPos());
    }

    public TesseractReference get(World world, BlockPos pos) {
        String dimension = world.func_234923_W_().func_240901_a_().toString();
        return (TesseractReference)this.tesseracts.putIfAbsent(dimension, new HashMap()).get(pos);
    }

    public CompoundNBT writeKey(TesseractReference reference) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("dimension", reference.getDimension());
        tag.func_74768_a("posx", reference.getPos().func_177958_n());
        tag.func_74768_a("posy", reference.getPos().func_177956_o());
        tag.func_74768_a("posz", reference.getPos().func_177952_p());
        return tag;
    }

    public TesseractReference fromKey(CompoundNBT key) {
        String dimension = key.func_74779_i("dimension");
        BlockPos pos = new BlockPos(key.func_74762_e("posx"), key.func_74762_e("posy"), key.func_74762_e("posz"));
        return this.tesseracts.containsKey(dimension) ? this.tesseracts.get(dimension).get(pos) : null;
    }

    @SubscribeEvent
    public static void onSave(WorldEvent.Save e) {
        if (e.getWorld().func_201670_d() || !(e.getWorld() instanceof World) || ((World)e.getWorld()).func_234923_W_() != World.field_234918_g_) {
            return;
        }
        File directory = new File(((ServerWorld)e.getWorld()).func_73046_m().func_240776_a_(FolderName.field_237253_i_).toFile(), "tesseract/tracking");
        int index = 0;
        for (Map.Entry<String, HashMap<BlockPos, TesseractReference>> dimensionEntry : TesseractTracker.SERVER.tesseracts.entrySet()) {
            for (Map.Entry<BlockPos, TesseractReference> entry : dimensionEntry.getValue().entrySet()) {
                File file = new File(directory, "tesseract" + index++ + ".nbt");
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    CompressedStreamTools.func_74795_b((CompoundNBT)entry.getValue().write(), (File)file);
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLoad(WorldEvent.Load e) {
        if (e.getWorld().func_201670_d() || !(e.getWorld() instanceof World) || ((World)e.getWorld()).func_234923_W_() != World.field_234918_g_) {
            return;
        }
        minecraftServer = ((ServerWorld)e.getWorld()).func_73046_m();
        TesseractTracker.SERVER.tesseracts.clear();
        File directory = new File(((ServerWorld)e.getWorld()).func_73046_m().func_240776_a_(FolderName.field_237253_i_).toFile(), "tesseract/tracking");
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : directory.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".nbt")) continue;
                try {
                    CompoundNBT tag = CompressedStreamTools.func_74797_a((File)file);
                    TesseractReference location = new TesseractReference(tag);
                    TesseractTracker.SERVER.tesseracts.putIfAbsent(location.getDimension(), new HashMap());
                    TesseractTracker.SERVER.tesseracts.get(location.getDimension()).put(location.getPos(), location);
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.world.field_72995_K || e.phase != TickEvent.Phase.END || e.world.func_234923_W_() != World.field_234918_g_) {
            return;
        }
        TesseractTracker.SERVER.toBeRemoved.forEach(SERVER::removeAndUpdate);
        TesseractTracker.SERVER.toBeRemoved.clear();
    }

    static {
        SERVER = new TesseractTracker();
    }
}

