/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.packets.PacketScreenCycleRedstoneState;
import com.supermartijn642.tesseract.screen.CycleButton;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RedstoneButton
extends CycleButton
implements IHoverTextWidget {
    public RedstoneState state;
    private BlockPos pos;

    public RedstoneButton(int x, int y) {
        super(x, y, 60);
    }

    public void update(TesseractTile tile) {
        this.state = tile.getRedstoneState();
        this.pos = tile.func_174877_v();
    }

    @Override
    protected int getCycleIndex() {
        return this.state == RedstoneState.DISABLED ? 0 : (this.state == RedstoneState.HIGH ? 1 : 2);
    }

    public void onPress() {
        super.onPress();
        if (this.pos != null) {
            Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenCycleRedstoneState(this.pos));
        }
    }

    protected ITextComponent getNarrationMessage() {
        return this.getHoverText();
    }

    public ITextComponent getHoverText() {
        return new TranslationTextComponent("gui.tesseract.redstone.speech", new Object[]{this.state.translate()});
    }
}

