/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen.info;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InfoPageButton
extends AbstractButtonWidget {
    private static final ResourceLocation BUTTONS = new ResourceLocation("tesseract", "textures/gui/page_navigation.png");
    private final int pageIndex;
    private final Supplier<Integer> currentPage;

    public InfoPageButton(int x, int y, int width, int height, int pageIndex, Supplier<Integer> currentPage, Consumer<Integer> setPage) {
        super(x, y, width, height, () -> setPage.accept(pageIndex));
        this.pageIndex = pageIndex;
        this.currentPage = currentPage;
    }

    protected ITextComponent getNarrationMessage() {
        return new TranslationTextComponent("gui.tesseract.info.narrate_page", new Object[]{this.pageIndex});
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ScreenUtils.bindTexture((ResourceLocation)BUTTONS);
        boolean selected = this.currentPage.get() == this.pageIndex;
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.3888889f, (float)((float)(this.active ? (selected ? 2 : (this.hovered ? 1 : 0)) : 3) / 4.0f), (float)0.22222222f, (float)0.25f);
    }
}

