/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen.info.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public abstract class RenderableBlock {
    private static final IRenderTypeBuffer.Impl MODEL_BUFFER = IRenderTypeBuffer.func_228455_a_((BufferBuilder)new BufferBuilder(128));
    private final float rotation;
    private final int x;
    private final int y;
    private final int z;

    public RenderableBlock(float rotation, int x, int y, int z) {
        this.rotation = rotation;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void render(MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.x, (double)this.y, (double)this.z);
        if (this.rotation != 0.0f) {
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(new Quaternion(0.0f, this.rotation, 0.0f, true));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        }
        this.renderInternal(matrixStack);
        matrixStack.func_227865_b_();
    }

    protected abstract void renderInternal(MatrixStack var1);

    public static RenderableBlock of(final ResourceLocation modelLocation, float rotation, int x, int y, int z) {
        return new RenderableBlock(rotation, x, y, z){

            @Override
            public void renderInternal(MatrixStack matrixStack) {
                IBakedModel model = ClientUtils.getBlockRenderer().func_175023_a().func_178126_b().getModel(modelLocation);
                ClientUtils.getBlockRenderer().func_175019_b().renderModel(matrixStack.func_227866_c_(), MODEL_BUFFER.getBuffer(RenderType.func_228639_c_()), null, model, 1.0f, 1.0f, 1.0f, 0, 0, (IModelData)EmptyModelData.INSTANCE);
            }
        };
    }

    public static RenderableBlock of(final Block block, float rotation, int x, int y, int z) {
        return new RenderableBlock(rotation, x, y, z){

            @Override
            public void renderInternal(MatrixStack matrixStack) {
                IBakedModel model = ClientUtils.getBlockRenderer().func_184389_a(block.func_176223_P());
                ClientUtils.getBlockRenderer().func_175019_b().renderModel(matrixStack.func_227866_c_(), MODEL_BUFFER.getBuffer(RenderType.func_228639_c_()), null, model, 1.0f, 1.0f, 1.0f, 0, 0, (IModelData)EmptyModelData.INSTANCE);
            }
        };
    }

    public static RenderableBlock of(final BlockState state, float rotation, int x, int y, int z) {
        return new RenderableBlock(rotation, x, y, z){

            @Override
            public void renderInternal(MatrixStack matrixStack) {
                IBakedModel model = ClientUtils.getBlockRenderer().func_184389_a(state);
                ClientUtils.getBlockRenderer().func_175019_b().renderModel(matrixStack.func_227866_c_(), MODEL_BUFFER.getBuffer(RenderType.func_228639_c_()), null, model, 1.0f, 1.0f, 1.0f, 0, 0, (IModelData)EmptyModelData.INSTANCE);
            }
        };
    }
}

