/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.capability;

import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.capability.IPlayerCapability;
import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerCapabilityManager
implements IPlayerCapability,
ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    protected boolean incapacitated = false;
    protected int ticksUntilDeath;
    protected int downsUntilDeath;
    protected int giveUpJumps;
    protected int reviveCounter;
    protected int jumpDelay;
    public final LazyOptional<IPlayerCapability> holder;

    public PlayerCapabilityManager() {
        this.ticksUntilDeath = Incapacitated.config.DOWNTICKS.get();
        this.downsUntilDeath = Incapacitated.config.DOWNCOUNT.get();
        this.giveUpJumps = 3;
        this.reviveCounter = Incapacitated.config.REVIVETICKS.get();
        this.jumpDelay = 0;
        this.holder = LazyOptional.of(() -> this);
    }

    @Override
    public boolean getIsIncapacitated() {
        return this.incapacitated;
    }

    @Override
    public void setIsIncapacitated(boolean isIncapacitated) {
        this.incapacitated = isIncapacitated;
    }

    @Override
    public int getTicksUntilDeath() {
        return this.ticksUntilDeath;
    }

    @Override
    public boolean countTicksUntilDeath() {
        --this.ticksUntilDeath;
        return this.ticksUntilDeath <= 0;
    }

    @Override
    public void setTicksUntilDeath(int ticks) {
        this.ticksUntilDeath = ticks;
    }

    @Override
    public int getDownsUntilDeath() {
        return this.downsUntilDeath;
    }

    @Override
    public void setDownsUntilDeath(int downs) {
        this.downsUntilDeath = downs;
    }

    @Override
    public boolean giveUpJumpCount() {
        --this.giveUpJumps;
        return this.giveUpJumps <= 0;
    }

    @Override
    public void resetGiveUpJumps() {
        this.giveUpJumps = 3;
    }

    @Override
    public int getJumpCount() {
        return this.giveUpJumps;
    }

    @Override
    public void setJumpCount(int jumps) {
        this.giveUpJumps = jumps;
    }

    @Override
    public boolean downReviveCount() {
        --this.reviveCounter;
        return this.reviveCounter <= 0;
    }

    @Override
    public int getReviveCount() {
        return this.reviveCounter;
    }

    @Override
    public void setReviveCount(int count) {
        this.reviveCounter = count;
    }

    @Override
    public int getJumpDelay() {
        return this.jumpDelay;
    }

    @Override
    public void setJumpDelay(int delay) {
        this.jumpDelay = delay;
    }

    @Override
    public void countDelay() {
        if (this.jumpDelay > 0) {
            --this.jumpDelay;
        } else if (this.jumpDelay < 0) {
            this.jumpDelay = 0;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PlayerCapability.INSTANCE) {
            return PlayerCapability.INSTANCE.orEmpty(cap, this.holder);
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("incapacitation", this.incapacitated);
        tag.func_74768_a("incapTimer", this.ticksUntilDeath);
        tag.func_74768_a("incapCounter", this.downsUntilDeath);
        tag.func_74768_a("jumpCounter", this.giveUpJumps);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.incapacitated = tag.func_74767_n("incapacitation");
        this.ticksUntilDeath = tag.func_74762_e("incapTimer");
        this.downsUntilDeath = tag.func_74762_e("incapCounter");
        this.giveUpJumps = tag.func_74762_e("jumpCounter");
    }
}

