/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.events;

import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import com.cartoonishvillain.incapacitated.capability.PlayerCapabilityManager;
import com.cartoonishvillain.incapacitated.events.BleedOutDamage;
import com.cartoonishvillain.incapacitated.networking.IncapPacket;
import com.cartoonishvillain.incapacitated.networking.incapacitationMessenger;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="incapacitated", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void playerRegister(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            PlayerCapabilityManager provider = new PlayerCapabilityManager();
            event.addCapability(new ResourceLocation("incapacitated", "incapacitated"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.isCanceled()) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (!(h.getIsIncapacitated() || Incapacitated.config.SOMEINSTANTKILLS.get().booleanValue() && Incapacitated.instantKillDamageSourcesMessageID.contains(event.getSource().func_76355_l()))) {
                    h.setDownsUntilDeath(h.getDownsUntilDeath() - 1);
                    if (h.getDownsUntilDeath() > -1) {
                        h.setIsIncapacitated(true);
                        event.setCanceled(true);
                        player.func_70606_j(player.func_110138_aP());
                        if (Incapacitated.config.GLOWING.get().booleanValue()) {
                            player.func_195064_c(new EffectInstance(Effects.field_188423_x, Integer.MAX_VALUE, 0));
                        }
                        incapacitationMessenger.sendTo(new IncapPacket(player.func_145782_y(), true), player);
                        if (Incapacitated.config.GLOBALINCAPMESSAGES.get().booleanValue()) {
                            ForgeEvents.broadcast(player.func_184102_h(), new StringTextComponent(player.func_195047_I_() + " is incapacitated!"));
                        } else {
                            ArrayList playerEntities = (ArrayList)player.field_70170_p.func_217357_a(PlayerEntity.class, player.func_174813_aQ().func_186662_g(50.0));
                            for (PlayerEntity players : playerEntities) {
                                players.func_146105_b((ITextComponent)new StringTextComponent(player.func_195047_I_() + " is incapacitated!"), false);
                            }
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void PlayerJoinEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getWorld().func_201670_d()) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> incapacitationMessenger.sendTo(new IncapPacket(player.func_145782_y(), h.getIsIncapacitated()), player));
        }
    }

    @SubscribeEvent
    public static void playerCloneEvent(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            PlayerEntity originalPlayer = event.getOriginal();
            PlayerEntity newPlayer = event.getPlayer();
            AtomicBoolean incapacitated = new AtomicBoolean(false);
            AtomicInteger ticksUntilDeath = new AtomicInteger(Integer.MAX_VALUE);
            AtomicInteger downsUntilDeath = new AtomicInteger(Integer.MAX_VALUE);
            originalPlayer.revive();
            originalPlayer.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                incapacitated.set(h.getIsIncapacitated());
                ticksUntilDeath.set(h.getTicksUntilDeath());
                downsUntilDeath.set(h.getDownsUntilDeath());
            });
            originalPlayer.func_174812_G();
            newPlayer.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                h.setIsIncapacitated(incapacitated.get());
                h.setTicksUntilDeath(ticksUntilDeath.get());
                h.setDownsUntilDeath(downsUntilDeath.get());
            });
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        event.player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
            h.countDelay();
            if (h.getIsIncapacitated()) {
                if (event.player.getForcedPose() == null) {
                    event.player.setForcedPose(Pose.SWIMMING);
                }
                if (!event.player.field_70170_p.func_201670_d()) {
                    ArrayList playerEntities = (ArrayList)event.player.field_70170_p.func_217357_a(PlayerEntity.class, event.player.func_174813_aQ().func_186662_g(3.0));
                    boolean reviving = false;
                    PlayerEntity revivingPlayer = null;
                    for (PlayerEntity player : playerEntities) {
                        AtomicBoolean isTargetDown = new AtomicBoolean(false);
                        AtomicBoolean isReviverDown = new AtomicBoolean(false);
                        event.player.getCapability(PlayerCapability.INSTANCE).ifPresent(j -> isTargetDown.set(j.getIsIncapacitated()));
                        player.getCapability(PlayerCapability.INSTANCE).ifPresent(j -> isReviverDown.set(j.getIsIncapacitated()));
                        if (!player.func_213453_ef() || !isTargetDown.get() || isReviverDown.get()) continue;
                        reviving = true;
                        revivingPlayer = player;
                        break;
                    }
                    if (reviving) {
                        if (h.downReviveCount()) {
                            h.setIsIncapacitated(false);
                            event.player.setForcedPose(null);
                            h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                            h.setJumpCount(3);
                            event.player.func_195063_d(Effects.field_188423_x);
                            incapacitationMessenger.sendTo(new IncapPacket(event.player.func_145782_y(), false), event.player);
                            event.player.func_70606_j(event.player.func_110138_aP() / 3.0f);
                            event.player.field_70170_p.func_184148_a(null, event.player.func_226277_ct_(), event.player.func_226278_cu_(), event.player.func_226281_cx_(), SoundEvents.field_189107_dL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        } else {
                            event.player.func_146105_b((ITextComponent)new StringTextComponent("You are being revived! " + h.getReviveCount() / 20 + " seconds..").func_240699_a_(TextFormatting.GREEN), true);
                            revivingPlayer.func_146105_b((ITextComponent)new StringTextComponent("Reviving " + event.player.func_195047_I_() + " " + h.getReviveCount() / 20 + " seconds...").func_240699_a_(TextFormatting.GREEN), true);
                        }
                    } else {
                        if (h.countTicksUntilDeath()) {
                            event.player.func_70097_a(BleedOutDamage.playerOutOfTime((Entity)event.player), event.player.func_110138_aP() * 2.0f);
                            event.player.setForcedPose(null);
                            h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                            h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                            h.setJumpCount(3);
                            event.player.func_195063_d(Effects.field_188423_x);
                            h.setIsIncapacitated(false);
                            incapacitationMessenger.sendTo(new IncapPacket(event.player.func_145782_y(), false), event.player);
                        } else if (h.getTicksUntilDeath() % 20 == 0) {
                            event.player.func_146105_b((ITextComponent)new StringTextComponent("Incapacitated! Call for help or jump " + h.getJumpCount() + " times to give up! " + (float)h.getTicksUntilDeath() / 20.0f + " seconds left!").func_240699_a_(TextFormatting.RED), true);
                        }
                        if (h.getReviveCount() != Incapacitated.config.REVIVETICKS.get().intValue()) {
                            h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                        }
                    }
                }
            } else if (event.player.getForcedPose() != null) {
                event.player.setForcedPose(null);
            }
        });
    }

    @SubscribeEvent
    public static void playerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.func_201670_d()) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (h.getIsIncapacitated() && h.getJumpDelay() == 0 && h.giveUpJumpCount()) {
                    player.func_70097_a(BleedOutDamage.playerOutOfTime((Entity)player), player.func_110138_aP() * 2.0f);
                    player.setForcedPose(null);
                    h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                    h.setJumpCount(3);
                    player.func_195063_d(Effects.field_188423_x);
                    h.setIsIncapacitated(false);
                    incapacitationMessenger.sendTo(new IncapPacket(player.func_145782_y(), false), player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerInjured(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (h.getIsIncapacitated() && Incapacitated.config.INVINCIBLEDOWN.get().booleanValue() && !event.getSource().func_76355_l().equals("giveup") && !event.getSource().func_76355_l().equals("bleedout")) {
                    event.setCanceled(true);
                    return;
                }
                h.setJumpDelay(20);
            });
        }
    }

    @SubscribeEvent
    public static void playerEat(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.func_201670_d()) {
            Item item = event.getItem().func_77973_b();
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (Incapacitated.HealingFoods.contains(item.getRegistryName())) {
                    h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                    h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                }
                if (h.getIsIncapacitated()) {
                    if (Incapacitated.ReviveFoods.contains(item.getRegistryName())) {
                        h.setIsIncapacitated(false);
                        player.setForcedPose(null);
                        h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                        h.setJumpCount(3);
                        h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                        h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                        player.func_195063_d(Effects.field_188423_x);
                        incapacitationMessenger.sendTo(new IncapPacket(player.func_145782_y(), false), player);
                        player.func_70606_j(player.func_110138_aP() / 3.0f);
                        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_189107_dL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                } else if (Incapacitated.ReviveFoods.contains(item.getRegistryName())) {
                    h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                    h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                }
            });
        }
    }

    private static void broadcast(MinecraftServer server, StringTextComponent translationTextComponent) {
        server.func_184103_al().func_232641_a_((ITextComponent)translationTextComponent, ChatType.CHAT, UUID.randomUUID());
    }
}

