/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.networking;

import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class IncapPacket {
    private int ID;
    private Boolean isIncapacitated;

    public IncapPacket(int id, boolean isIncapacitated) {
        this.ID = id;
        this.isIncapacitated = isIncapacitated;
    }

    public IncapPacket(PacketBuffer packetBuffer) {
        this.ID = packetBuffer.readInt();
        this.isIncapacitated = packetBuffer.readBoolean();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.ID);
        buffer.writeBoolean(this.isIncapacitated.booleanValue());
    }

    public static IncapPacket decode(PacketBuffer buf) {
        return new IncapPacket(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.ID);
            if (entity != null) {
                entity.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> h.setIsIncapacitated(this.isIncapacitated));
            }
        });
        context.setPacketHandled(true);
    }
}

