/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import io.github.noeppi_noeppi.libx.inventory.container.ContainerBase;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.BlockGUI;
import io.github.noeppi_noeppi.libx.render.ItemStackRenderer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.wand.IWandHUD;

public abstract class BotanicalBlock<T extends BotanicalTile, C extends ContainerBase<T>>
extends BlockGUI<T, C>
implements IWandHUD {
    public static final VoxelShape FRAME_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BotanicalBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BotanicalBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0), BotanicalBlock.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), BotanicalBlock.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0), BotanicalBlock.func_208617_a((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), BotanicalBlock.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), BotanicalBlock.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), BotanicalBlock.func_208617_a((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), BotanicalBlock.func_208617_a((double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)});
    public final boolean fullCube;
    public final boolean specialRender;

    public BotanicalBlock(ModX mod, Class<T> teClass, ContainerType<C> container, boolean fullCube, boolean specialRender) {
        super(mod, teClass, container, fullCube ? AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 10.0f) : AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 10.0f).func_208770_d(), specialRender ? new Item.Properties().setISTER(() -> ItemStackRenderer::get) : new Item.Properties());
        this.fullCube = fullCube;
        this.specialRender = specialRender;
    }

    public void registerClient(ResourceLocation id) {
        if (!this.fullCube) {
            RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_());
        }
        if (this.specialRender) {
            ItemStackRenderer.addRenderTile((TileEntityType)this.getTileType(), (boolean)true);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BotanicalTile tile = (BotanicalTile)world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        CompoundNBT nbt = tile.serializeNBT();
        ItemStack stack = new ItemStack((IItemProvider)this);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    public int func_180641_l(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return ((BotanicalTile)this.getTile(world, pos)).getComparatorOutput();
    }

    public void renderHUD(MatrixStack ms, Minecraft mc, World world, BlockPos pos) {
        ((BotanicalTile)this.getTile(world, pos)).renderHUD(ms, mc);
    }

    public int func_200011_d(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return !this.fullCube ? 0 : super.func_200011_d(state, world, pos);
    }

    public boolean func_200123_i(@Nonnull BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos) {
        return !this.fullCube;
    }

    public boolean func_220074_n(@Nonnull BlockState state) {
        return !this.fullCube;
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return !this.fullCube ? FRAME_SHAPE : super.func_220053_a(state, world, pos, context);
    }

    protected boolean shouldDropInventory(World world, BlockPos pos, BlockState state) {
        return false;
    }
}

