/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.melanx.botanicalmachinery.blocks.tiles.TileIndustrialAgglomerationFactory;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import io.github.noeppi_noeppi.libx.block.tesr.HorizontalRotatedTesr;
import io.github.noeppi_noeppi.libx.render.RenderHelperItem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.RenderHelper;

public class TesrIndustrialAgglomerationFactory
extends HorizontalRotatedTesr<TileIndustrialAgglomerationFactory> {
    public TesrIndustrialAgglomerationFactory(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    protected void doRender(@Nonnull TileIndustrialAgglomerationFactory tile, float partialTicks, @Nonnull MatrixStack ms, @Nonnull IRenderTypeBuffer buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.industrialAgglomerationFactory) {
            return;
        }
        double progressLeft = 1.0 - (double)tile.getProgress() / (double)tile.getMaxProgress();
        this.renderStack(tile.getInventory().getStackInSlot(0), ms, buffer, partialTicks, progressLeft, 0.0f);
        this.renderStack(tile.getInventory().getStackInSlot(1), ms, buffer, partialTicks, progressLeft, 120.0f);
        this.renderStack(tile.getInventory().getStackInSlot(2), ms, buffer, partialTicks, progressLeft, 240.0f);
        if (!tile.getInventory().getStackInSlot(3).func_190926_b()) {
            float time = (float)ClientTickHandler.ticksInGame + partialTicks;
            ms.func_227860_a_();
            ms.func_227861_a_(0.5, 0.7, 0.5);
            ms.func_227862_a_(0.3f, 0.3f, 0.3f);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-time));
            ms.func_227861_a_(0.0, 0.075 * Math.sin((double)time / 5.0), 0.0);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(tile.getInventory().getStackInSlot(3), ItemCameraTransforms.TransformType.GROUND, 200, OverlayTexture.field_229196_a_, ms, buffer);
            ms.func_227865_b_();
        }
        if (tile.getProgress() > 0) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.3875, 0.29375, 0.3875);
            ms.func_227862_a_(0.225f, 0.225f, 0.225f);
            float alphaMod = 50000.0f * ((float)tile.getProgress() / (float)tile.getMaxProgress());
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            ms.func_227861_a_(0.0, 0.0, (double)-0.1885f);
            float alpha = (float)((Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) / 8.0f) + 1.0) / 5.0 + 0.6) * alphaMod;
            IVertexBuilder vertex = buffer.getBuffer(RenderHelper.TERRA_PLATE);
            IconHelper.renderIcon((MatrixStack)ms, (IVertexBuilder)vertex, (int)0, (int)0, (TextureAtlasSprite)MiscellaneousIcons.INSTANCE.terraPlateOverlay.func_229314_c_(), (int)1, (int)1, (float)alpha);
            ms.func_227865_b_();
        }
    }

    private void renderStack(ItemStack stack, @Nonnull MatrixStack ms, @Nonnull IRenderTypeBuffer buffer, float partialTicks, double progressLeft, float angle) {
        if (!stack.func_190926_b()) {
            double progressLeftScaled = progressLeft * 0.95;
            float time = (float)ClientTickHandler.ticksInGame + partialTicks;
            float colorTint = (float)Math.min(1.0, progressLeft * 1.2);
            ms.func_227860_a_();
            ms.func_227861_a_(0.5, (10.4 - 4.0 * progressLeft) / 16.0, 0.5);
            ms.func_227862_a_(0.3f, 0.3f, 0.3f);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle + time));
            ms.func_227861_a_(progressLeftScaled * 1.125, 0.0, progressLeftScaled * 0.25);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            ms.func_227861_a_(0.0, 0.075 * Math.sin((double)(time + angle) / 5.0), 0.0);
            RenderHelperItem.renderItemTinted((ItemStack)stack, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (int)200, (int)OverlayTexture.field_229196_a_, (MatrixStack)ms, (IRenderTypeBuffer)buffer, (float)colorTint, (float)1.0f, (float)colorTint, (float)1.0f);
            ms.func_227865_b_();
        }
    }
}

