/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.melanx.botanicalmachinery.blocks.tiles.TileMechanicalManaPool;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import io.github.noeppi_noeppi.libx.block.tesr.HorizontalRotatedTesr;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.api.mana.IPoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.RenderHelper;

public class TesrMechanicalManaPool
extends HorizontalRotatedTesr<TileMechanicalManaPool> {
    public static final double INNER_POOL_HEIGHT = 0.28125;
    public static final double POOL_BOTTOM_HEIGHT = 0.071875;

    public TesrMechanicalManaPool(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    protected void doRender(@Nonnull TileMechanicalManaPool tile, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalManaPool) {
            return;
        }
        ItemStack catalystStack = tile.getInventory().getStackInSlot(0);
        if (!catalystStack.func_190926_b() && catalystStack.func_77973_b() instanceof BlockItem && ((BlockItem)catalystStack.func_77973_b()).func_179223_d() instanceof IPoolOverlayProvider) {
            IPoolOverlayProvider catalyst = (IPoolOverlayProvider)((BlockItem)catalystStack.func_77973_b()).func_179223_d();
            TextureAtlasSprite sprite = catalyst.getIcon(tile.func_145831_w(), tile.func_174877_v());
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.125, 0.071875, 0.125);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
            float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + partialTicks) / 20.0) + 1.0) * 0.3 + 0.2);
            IVertexBuilder vertex = buffer.getBuffer(RenderHelper.ICON_OVERLAY);
            IconHelper.renderIcon((MatrixStack)matrixStack, (IVertexBuilder)vertex, (int)0, (int)0, (TextureAtlasSprite)sprite, (int)12, (int)12, (float)alpha);
            matrixStack.func_227865_b_();
        }
        if (tile.getCurrentMana() > 0) {
            double amount = (double)tile.getCurrentMana() / (double)tile.getManaCap();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.1875, 0.071875 + amount * 0.28125, 0.1875);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
            IVertexBuilder vertex = buffer.getBuffer(RenderHelper.MANA_POOL_WATER);
            IconHelper.renderIcon((MatrixStack)matrixStack, (IVertexBuilder)vertex, (int)0, (int)0, (TextureAtlasSprite)MiscellaneousIcons.INSTANCE.manaWater.func_229314_c_(), (int)10, (int)10, (float)1.0f);
            matrixStack.func_227865_b_();
        }
        ItemStack input = tile.getInventory().getStackInSlot(1);
        ItemStack output = tile.getInventory().getStackInSlot(2);
        if (!input.func_190926_b() || !output.func_190926_b()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.3125, 0.4375, 0.5);
            if (!output.func_190926_b()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(0.4375f, 0.4375f, 0.4375f);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)ClientTickHandler.ticksInGame + partialTicks));
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(output, ItemCameraTransforms.TransformType.GROUND, 200, OverlayTexture.field_229196_a_, matrixStack, buffer);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227861_a_(0.375, 0.0, 0.0);
            if (!input.func_190926_b()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(0.4375f, 0.4375f, 0.4375f);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(ClientTickHandler.ticksInGame % 360)));
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(input, ItemCameraTransforms.TransformType.GROUND, 200, OverlayTexture.field_229196_a_, matrixStack, buffer);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
    }
}

