/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.api.common.head;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.api.common.PlacementCorrector;
import me.ichun.mods.ichunutil.api.common.head.HeadInfoDelegate;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeadInfo<E extends LivingEntity> {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final Splitter DOT_SPLITTER = Splitter.on((String)".").trimResults().omitEmptyStrings();
    public static BooleanSupplier horseEasterEgg = () -> false;
    public static BooleanSupplier acidEyesBooleanSupplier = () -> false;
    public static IntSupplier aggressiveHeadTracking = () -> 0;
    public transient boolean hasStrippedInfo = false;
    @OnlyIn(value=Dist.CLIENT)
    public transient ModelRenderer headModel;
    @OnlyIn(value=Dist.CLIENT)
    public transient ModelRenderer[] childTranslates;
    public transient Field[] fields = null;
    public transient ArrayList<Integer>[] fieldIndex = null;
    public transient float[] headJoint = new float[3];
    public transient Random rand = new Random();
    public transient int[] acidTime;
    @OnlyIn(value=Dist.CLIENT)
    public transient MatrixStack renderCorrectorStack;
    public transient Class<? extends EntityModel> multiModelClass = null;
    public String author = null;
    public String forClass = null;
    public String customClass = null;
    public String modelFieldName = "THIS SHOULD BE FILLED UP";
    public Boolean isBoss = false;
    public Boolean affectedByInvisibility = true;
    public PlacementCorrector[] renderCorrectors = null;
    public float[] childEntityScale = null;
    public float[] childEntityOffset = null;
    public Boolean noFaceInfo = false;
    public float[] eyeOffset = new float[]{0.0f, 0.25f, 0.25f};
    @SerializedName(value="irisColour")
    public float[] corneaColour = new float[]{0.8980392f, 0.8980392f, 0.8980392f};
    @SerializedName(value="pupilColour")
    public float[] irisColour = new float[]{0.0f, 0.0f, 0.0f};
    public Float halfInterpupillaryDistance = Float.valueOf(0.125f);
    public Float eyeScale = Float.valueOf(0.75f);
    public Boolean sideEyed = false;
    public Boolean topEyed = false;
    public Float eyeYRotation = Float.valueOf(0.0f);
    public Float eyeXRotation = Float.valueOf(0.0f);
    public Integer eyeCount = 2;
    public Boolean doesEyeGlow = false;
    public Boolean noTopInfo = false;
    public float[] headTopCenter = new float[]{0.0f, 0.5f, 0.0f};
    public Float headScale = Float.valueOf(1.0f);
    public Float hatTiltPitch = Float.valueOf(0.0f);
    public Float hatTiltYaw = Float.valueOf(0.0f);
    public float[] headArmorOffset = new float[]{0.0f, 0.0625f, 0.0f};
    public Float headArmorScale = Float.valueOf(1.27f);
    public HeadInfo[] additionalHeads = null;
    public HeadInfo[] multiModel = null;

    public boolean affectedByInvisibility(E living, int eye) {
        return this.affectedByInvisibility;
    }

    public boolean doesEyeGlow(E living, int eye) {
        return this.doesEyeGlow;
    }

    public int getEyeCount(E living) {
        return this.eyeCount;
    }

    public int getHeadCount(E living) {
        return this.additionalHeads != null ? this.additionalHeads.length + 1 : 1;
    }

    public HeadInfo getHeadInfo(E living, int head) {
        if (head > 0) {
            return this.additionalHeads[head - 1];
        }
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void correctPosition(E living, MatrixStack stack, float partialTick) {
        if (this.renderCorrectors != null && this.renderCorrectors.length > 0) {
            if (this.renderCorrectorStack == null) {
                this.renderCorrectorStack = new MatrixStack();
                for (PlacementCorrector renderCorrector : this.renderCorrectors) {
                    renderCorrector.apply(this.renderCorrectorStack);
                }
            }
            PlacementCorrector.multiplyStackWithStack(stack, this.renderCorrectorStack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getHeadJointOffset(E living, MatrixStack stack, float partialTick, int head) {
        this.headJoint[0] = -(this.headModel.field_78800_c / 16.0f);
        this.headJoint[1] = -(this.headModel.field_78797_d / 16.0f);
        this.headJoint[2] = -(this.headModel.field_78798_e / 16.0f);
        return this.headJoint;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getEyeOffsetFromJoint(E living, MatrixStack stack, float partialTick, int eye) {
        return this.eyeOffset;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEyeSideOffset(E living, MatrixStack stack, float partialTick, int eye) {
        return eye == 0 ? this.halfInterpupillaryDistance.floatValue() : -this.halfInterpupillaryDistance.floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEyeScale(E living, MatrixStack stack, float partialTick, int eye) {
        return this.eyeScale.floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEyeRotation(E living, MatrixStack stack, float partialTick, int eye) {
        return this.sideEyed.booleanValue() ? (eye % 2 == 0 ? 90.0f : -90.0f) : (eye % 2 == 0 ? this.eyeYRotation.floatValue() : -this.eyeYRotation.floatValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEyeTopRotation(E living, MatrixStack stack, float partialTick, int eye) {
        return this.topEyed != false ? -90.0f : this.eyeXRotation.floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getIrisScale(E living, MatrixStack stack, float partialTick, int eye) {
        if (acidEyesBooleanSupplier.getAsBoolean() || (Integer)living.func_184212_Q().func_187225_a(LivingEntity.field_184633_f) > 0) {
            this.rand.setSeed((long)Math.abs(living.hashCode()) * 1000L);
            int eyeCount = this.getEyeCount(living);
            if (this.acidTime == null || this.acidTime.length < eyeCount) {
                this.acidTime = new int[eyeCount];
            }
            for (int i = 0; i < eyeCount; ++i) {
                this.acidTime[i] = 20 + this.rand.nextInt(20);
            }
            return 0.3f + ((float)Math.sin(Math.toRadians(((float)((LivingEntity)living).field_70173_aa + partialTick) / (float)this.acidTime[eye] * 360.0f)) + 1.0f) / 2.0f;
        }
        return 1.0f + 0.35f * ((float)((LivingEntity)living).field_70725_aQ + partialTick) / 20.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getCorneaColours(E living, MatrixStack stack, float partialTick, int eye) {
        return this.corneaColour;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getIrisColours(E living, MatrixStack stack, float partialTick, int eye) {
        return this.irisColour;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getHatOffsetFromJoint(E living, MatrixStack stack, float partialTick, int head) {
        return this.headTopCenter;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHatScale(E living, MatrixStack stack, float partialTick, int head) {
        return this.headScale.floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHatYaw(E living, MatrixStack stack, float partialTick, int head) {
        return this.hatTiltYaw.floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHatPitch(E living, MatrixStack stack, float partialTick, int head) {
        return this.hatTiltPitch.floatValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadYaw(E living, MatrixStack stack, float partialTick, int head, int eye) {
        return (float)Math.toDegrees(this.headModel.field_78796_g);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadPitch(E living, MatrixStack stack, float partialTick, int head, int eye) {
        return (float)Math.toDegrees(this.headModel.field_78795_f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRoll(E living, MatrixStack stack, float partialTick, int head, int eye) {
        return (float)Math.toDegrees(this.headModel.field_78808_h);
    }

    public float getHeadYaw(E living, float partialTick, int head, int eye) {
        return ((LivingEntity)living).field_70758_at + (((LivingEntity)living).field_70759_as - ((LivingEntity)living).field_70758_at) * partialTick;
    }

    public float getHeadPitch(E living, float partialTick, int head, int eye) {
        return ((LivingEntity)living).field_70127_C + (((LivingEntity)living).field_70125_A - ((LivingEntity)living).field_70127_C) * partialTick;
    }

    public float getHeadRoll(E living, float partialTick, int head, int eye) {
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getHeadArmorOffset(E living, MatrixStack stack, float partialTick, int head) {
        return !living.func_184582_a(EquipmentSlotType.HEAD).func_190926_b() ? this.headArmorOffset : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadArmorScale(E living, MatrixStack stack, float partialTick, int head) {
        return !living.func_184582_a(EquipmentSlotType.HEAD).func_190926_b() ? this.headArmorScale.floatValue() : 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postHeadTranslation(E living, MatrixStack stack, float partialTick) {
        if (this.childTranslates != null) {
            for (ModelRenderer child : this.childTranslates) {
                this.translateRotateToChild(living, stack, child);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void preChildEntHeadRenderCalls(E living, MatrixStack stack, LivingRenderer<E, ?> render) {
        if (living.func_70631_g_()) {
            if (this.childEntityScale != null || this.childEntityOffset != null) {
                if (this.childEntityScale != null) {
                    stack.func_227862_a_(this.childEntityScale[0], this.childEntityScale[1], this.childEntityScale[2]);
                }
                if (this.childEntityOffset != null) {
                    stack.func_227861_a_((double)this.childEntityOffset[0], (double)this.childEntityOffset[1], (double)this.childEntityOffset[2]);
                }
            } else {
                float modelScale = 0.0625f;
                EntityModel model = render.func_217764_d();
                if (model instanceof BipedModel) {
                    stack.func_227862_a_(0.75f, 0.75f, 0.75f);
                    stack.func_227861_a_(0.0, (double)(16.0f * modelScale), 0.0);
                } else if (model instanceof AgeableModel) {
                    AgeableModel ageableModel = (AgeableModel)model;
                    if (ageableModel.field_228221_a_) {
                        float f = 1.5f / ageableModel.field_228224_g_;
                        stack.func_227862_a_(f, f, f);
                    }
                    stack.func_227861_a_(0.0, (double)(ageableModel.field_228222_b_ * modelScale), (double)(ageableModel.field_228223_f_ * modelScale));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void translateRotateToChild(E living, MatrixStack stack, ModelRenderer renderer) {
        stack.func_227861_a_((double)(renderer.field_78800_c / 16.0f), (double)(renderer.field_78797_d / 16.0f), (double)(renderer.field_78798_e / 16.0f));
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(renderer.field_78808_h));
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(renderer.field_78796_g));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(renderer.field_78795_f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean setup(E living, LivingRenderer renderer) {
        return true;
    }

    public boolean setup(E living) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setHeadModel(E living, LivingRenderer renderer) {
        if (this.headModel == null || aggressiveHeadTracking.getAsInt() == 1 || aggressiveHeadTracking.getAsInt() == 2 && renderer instanceof PlayerRenderer) {
            this.setHeadModelFromRenderer(living, renderer, renderer.func_217764_d());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void setHeadModelFromRenderer(E living, LivingRenderer renderer, EntityModel model) {
        if (this.fieldIndex == null) {
            List fieldNames = DOT_SPLITTER.splitToList((CharSequence)this.modelFieldName);
            this.fields = new Field[fieldNames.size()];
            this.fieldIndex = new ArrayList[fieldNames.size()];
            boolean flag = false;
            for (int i = 0; i < fieldNames.size(); ++i) {
                String fieldNameFull;
                String fieldName = fieldNameFull = (String)fieldNames.get(i);
                ArrayList<Integer> indices = new ArrayList<Integer>();
                if (fieldName.contains("[")) {
                    fieldName = fieldNameFull.substring(0, fieldNameFull.indexOf("["));
                    String indicesString = fieldNameFull.substring(fieldNameFull.indexOf("["));
                    while (indicesString.startsWith("[")) {
                        int closeBracketIndex = indicesString.indexOf("]");
                        try {
                            indices.add(Integer.parseInt(indicesString.substring(1, closeBracketIndex)));
                        }
                        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                            LOGGER.error("Error parsing modelFieldName of {} for {} of model {} in {}", (Object)this.modelFieldName, (Object)this.getClass().getSimpleName(), (Object)model.getClass().getSimpleName(), (Object)renderer.getClass().getSimpleName());
                            flag = true;
                            indices.add(-3);
                        }
                        indicesString = indicesString.substring(closeBracketIndex + 1);
                    }
                } else {
                    indices.add(-1);
                }
                Field field = HeadInfo.findField(model.getClass(), ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)fieldName));
                if (field != null) {
                    this.fields[i] = field;
                    this.fieldIndex[i] = indices;
                    continue;
                }
                flag = true;
                LOGGER.error("Error finding field of {} from {} for {} of model {} in {}", (Object)fieldName, (Object)this.modelFieldName, (Object)this.getClass().getSimpleName(), (Object)model.getClass().getSimpleName(), (Object)renderer.getClass().getSimpleName());
            }
            if (flag) {
                this.fields = null;
            } else if (this.fieldIndex.length > 1) {
                this.childTranslates = new ModelRenderer[this.fieldIndex.length - 1];
            }
        }
        if (this.fields != null) {
            Field field;
            for (int i = 0; i < this.fields.length && (field = this.fields[i]) != null; ++i) {
                field.setAccessible(true);
                if (i == 0 && !field.getDeclaringClass().isInstance(model)) break;
                ArrayList<Integer> indices = this.fieldIndex[i];
                try {
                    Object o;
                    Object modelAtIndex = o = field.get(model);
                    for (Integer index : indices) {
                        modelAtIndex = HeadInfo.digForModelRendererWithIndex(modelAtIndex, index);
                    }
                    if (!(modelAtIndex instanceof ModelRenderer)) continue;
                    if (i == 0) {
                        this.headModel = (ModelRenderer)modelAtIndex;
                        continue;
                    }
                    this.childTranslates[i - 1] = (ModelRenderer)modelAtIndex;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException | IllegalAccessException | NullPointerException e) {
                    LOGGER.error("Error getting head info of {} for {} in {}", (Object)this.modelFieldName, (Object)this.getClass().getSimpleName(), (Object)renderer.getClass().getSimpleName());
                    e.printStackTrace();
                }
            }
        }
    }

    @Nullable
    public static Field findField(Class clz, String fieldName) {
        Field f = null;
        try {
            f = clz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clz.getSuperclass() != EntityModel.class) {
                f = HeadInfo.findField(clz.getSuperclass(), fieldName);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return f;
    }

    @Nullable
    public static ModelRenderer digForModelRendererWithIndex(Object o, int index) {
        Object o2;
        if (o instanceof ModelRenderer) {
            if (index >= 0) {
                return (ModelRenderer)((ModelRenderer)o).field_78805_m.get(index);
            }
            return (ModelRenderer)o;
        }
        if (o.getClass().isArray() && ModelRenderer.class.isAssignableFrom(o.getClass().getComponentType())) {
            if (index >= 0) {
                return ((ModelRenderer[])o)[index];
            }
            return ((ModelRenderer[])o)[0];
        }
        if (o instanceof List && (o2 = ((List)o).get(index)) instanceof ModelRenderer) {
            return (ModelRenderer)o2;
        }
        return null;
    }

    public static class HeadHolder {
        @Nonnull
        public final HeadInfo<?> info;
        @Nonnull
        public final Class<? extends LivingEntity> clz;

        public HeadHolder(@Nonnull HeadInfo<?> info, @Nonnull Class<? extends LivingEntity> clz) {
            this.info = info;
            this.clz = clz;
        }
    }

    public static class Serializer
    implements JsonDeserializer<HeadInfo>,
    JsonSerializer<HeadInfo> {
        public JsonElement serialize(HeadInfo src, Type typeOfSrc, JsonSerializationContext context) {
            if (!src.hasStrippedInfo) {
                return context.serialize((Object)Serializer.createStrippedClone(src));
            }
            return new Gson().toJsonTree((Object)src);
        }

        private static HeadInfo createStrippedClone(HeadInfo src) {
            Gson gson = new Gson();
            HeadInfo defaultInfo = new HeadInfo();
            HeadInfo clone = (HeadInfo)gson.fromJson(gson.toJson((Object)src), src.getClass());
            for (Field field : HeadInfo.class.getDeclaredFields()) {
                field.setAccessible(true);
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                try {
                    if (field.get(clone) == null || !Serializer.isFieldValueEqual(field, clone, defaultInfo)) continue;
                    field.set(clone, null);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (clone.additionalHeads != null) {
                for (int i = 0; i < clone.additionalHeads.length; ++i) {
                    clone.additionalHeads[i] = Serializer.createStrippedClone(clone.additionalHeads[i]);
                }
            }
            if (clone.getClass() != HeadInfo.class) {
                clone.customClass = clone.getClass().getName();
            } else if (clone.modelFieldName == null || clone.modelFieldName.equals(defaultInfo.modelFieldName)) {
                LOGGER.error("HeadInfo is not using a custom class but hasn't set a head model.");
            }
            clone.hasStrippedInfo = true;
            return clone;
        }

        private static boolean isFieldValueEqual(Field field, HeadInfo clone, HeadInfo defaultInfo) throws IllegalAccessException {
            Object o1 = field.get(clone);
            Object o2 = field.get(defaultInfo);
            if (o1 == null && o2 != null || o2 == null && o1 != null) {
                return false;
            }
            if (o1 == null) {
                return true;
            }
            try {
                int l2;
                int l1;
                if (o1.getClass() == o2.getClass() && o1.getClass().isArray() && (l1 = Array.getLength(o1)) == (l2 = Array.getLength(o2))) {
                    for (int i = 0; i < l1; ++i) {
                        if (Array.get(o1, i).equals(Array.get(o2, i))) continue;
                        return false;
                    }
                    return true;
                }
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
            return o1.equals(o2);
        }

        public HeadInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = (JsonObject)json;
            if (jsonObject.has("multiModel") && jsonObject.getAsJsonArray("multiModel").size() > 0) {
                HeadInfoDelegate headInfo = (HeadInfoDelegate)context.deserialize(json, HeadInfoDelegate.class);
                headInfo.checkModels();
                return headInfo;
            }
            if (jsonObject.has("customClass")) {
                String forClass = jsonObject.has("forClass") ? jsonObject.get("forClass").getAsString() : "Unknown Class";
                String customClass = jsonObject.get("customClass").getAsString();
                try {
                    Class<?> clz = Class.forName(customClass);
                    HeadInfo deserialized = (HeadInfo)context.deserialize(json, clz);
                    HeadInfo defaultInfo = (HeadInfo)clz.newInstance();
                    for (Field field : HeadInfo.class.getDeclaredFields()) {
                        field.setAccessible(true);
                        if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                        try {
                            if (field.get(deserialized) != null) continue;
                            field.set(deserialized, field.get(defaultInfo));
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    return deserialized;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Cannot find custom head info class: " + customClass + " for class: " + forClass);
                    e.printStackTrace();
                }
                catch (ClassCastException | IllegalAccessException | InstantiationException e) {
                    LOGGER.error("Error creating custom class: " + customClass + " for class: " + forClass);
                    e.printStackTrace();
                }
            }
            return (HeadInfo)new Gson().fromJson(json, HeadInfo.class);
        }
    }
}

