/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.ResourceLocation;

public abstract class Fragment<P extends Fragment>
implements IConstrainable,
IConstrained,
INestedGuiEventHandler,
IRenderable {
    private static final ResourceLocation VANILLA_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation VANILLA_TAB_ITEMS = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    public static final ResourceLocation VANILLA_WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    private static final ResourceLocation VANILLA_STATS_ICON = new ResourceLocation("textures/gui/container/stats_icons.png");
    private static final ResourceLocation VANILLA_HORSE = new ResourceLocation("textures/gui/container/horse.png");
    private static final ResourceLocation TABS = new ResourceLocation("ichunutil", "textures/gui/bns/vanilla/tabs.png");
    private static final ResourceLocation TAB_ITEMS = new ResourceLocation("ichunutil", "textures/gui/bns/vanilla/tab_items.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("ichunutil", "textures/gui/bns/vanilla/widgets.png");
    private static final ResourceLocation STATS_ICON = new ResourceLocation("ichunutil", "textures/gui/bns/vanilla/stats_icons.png");
    private static final ResourceLocation HORSE = new ResourceLocation("ichunutil", "textures/gui/bns/vanilla/horse.png");
    public P parentFragment;
    @Nonnull
    public Constraint constraint = Constraint.NONE;
    @Nullable
    public String id;
    @Nullable
    private IGuiEventListener focused;
    private boolean isDragging;
    public int posX;
    public int posY;
    public int width;
    public int height;

    public ResourceLocation resourceTabs() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_TABS : TABS;
    }

    public ResourceLocation resourceTabItems() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_TAB_ITEMS : TAB_ITEMS;
    }

    public ResourceLocation resourceWidgets() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_WIDGETS : WIDGETS;
    }

    public ResourceLocation resourceStatsIcon() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_STATS_ICON : STATS_ICON;
    }

    public ResourceLocation resourceHorse() {
        return this.renderMinecraftStyle() == 2 ? VANILLA_HORSE : HORSE;
    }

    public Fragment(P parentFragment) {
        this.parentFragment = parentFragment;
    }

    public <T extends Fragment<?>> T setConstraint(Constraint constraint) {
        this.constraint = constraint;
        return (T)this;
    }

    @Nonnull
    public Constraint constraints() {
        if (this.constraint == Constraint.NONE) {
            this.constraint = new Constraint(this);
        }
        return this.constraint;
    }

    public <T extends Fragment<?>> T setId(String id) {
        this.id = id;
        return (T)this;
    }

    public Theme getTheme() {
        return ((Fragment)this.parentFragment).getTheme();
    }

    public int renderMinecraftStyle() {
        return ((Fragment)this.parentFragment).renderMinecraftStyle();
    }

    public abstract void init();

    public abstract List<? extends Fragment<?>> func_231039_at__();

    public <T extends Workspace> T getWorkspace() {
        return ((Fragment)this.parentFragment).getWorkspace();
    }

    public void tick() {
        this.func_231039_at__().forEach(Fragment::tick);
    }

    public void onClose() {
        this.func_231039_at__().forEach(Fragment::onClose);
    }

    @Nullable
    public <T extends Fragment<?>> T getById(@Nonnull String id) {
        if (id.equals(this.id)) {
            return (T)this;
        }
        T o = null;
        for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
            if (o != null || !(iGuiEventListener instanceof Fragment)) continue;
            o = ((Fragment)iGuiEventListener).getById(id);
        }
        return o;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return ((Fragment)this.parentFragment).func_231047_b_(mouseX, mouseY) && Fragment.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.width) && Fragment.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.height);
    }

    public static boolean isMouseBetween(double mousePos, double p1, double p2) {
        return mousePos >= p1 && mousePos < p2;
    }

    public FontRenderer getFontRenderer() {
        return ((Fragment)this.parentFragment).getFontRenderer();
    }

    public void drawString(MatrixStack stack, String s, float posX, float posY) {
        this.drawString(stack, s, posX, posY, this.renderMinecraftStyle() > 0 ? this.getMinecraftFontColour() : Theme.getAsHex(this.getTheme().font));
    }

    public void drawString(MatrixStack stack, String s, float posX, float posY, int color) {
        if (this.renderMinecraftStyle() > 0) {
            this.getFontRenderer().func_238405_a_(stack, s, posX, posY, color);
        } else {
            this.getFontRenderer().func_238421_b_(stack, s, posX, posY, color);
        }
    }

    public int getMinecraftFontColour() {
        return 0xFFFFFF;
    }

    @Nullable
    public Fragment<?> getTopMostFragment(double mouseX, double mouseY) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            Fragment<?> fragment = this;
            for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
                Fragment<?> fragment1;
                if (!(iGuiEventListener instanceof Fragment) || (fragment1 = ((Fragment)iGuiEventListener).getTopMostFragment(mouseX, mouseY)) == null) continue;
                fragment = fragment1;
            }
            return fragment;
        }
        return null;
    }

    public boolean requireScissor() {
        return false;
    }

    public void resetScissorToParent() {
        if (!((Fragment)this.parentFragment).requireScissor()) {
            ((Fragment)this.parentFragment).resetScissorToParent();
        } else {
            ((Fragment)this.parentFragment).setScissor();
        }
    }

    public void setScissor() {
        RenderHelper.startGlScissor(this.getLeft(), this.getTop(), this.width, this.height);
    }

    public void endScissor() {
        RenderHelper.endGlScissor();
    }

    public void fill(MatrixStack stack, int[] colours, int border) {
        this.fill(stack, colours, 255, border);
    }

    public void fill(MatrixStack stack, int[] colours, int alpha, int border) {
        RenderHelper.drawColour(stack, colours[0], colours[1], colours[2], alpha, this.getLeft() + border, this.getTop() + border, this.width - border * 2, this.height - border * 2, 0.0);
    }

    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        return null;
    }

    public String reString(String s, int length) {
        if (this.getFontRenderer().func_78256_a(s) > length) {
            String s1 = s;
            while (this.getFontRenderer().func_78256_a(s1 + "\u2026") > length) {
                s1 = s1.substring(0, s1.length() - 1);
            }
            return s1 + "\u2026";
        }
        return s;
    }

    public boolean func_231041_ay__() {
        return this.isDragging;
    }

    public void func_231037_b__(boolean b) {
        this.isDragging = b;
    }

    @Nullable
    public IGuiEventListener func_241217_q_() {
        return this.focused;
    }

    public void func_231035_a_(@Nullable IGuiEventListener iGuiEventListener) {
        IGuiEventListener lastFocused = this.func_241217_q_();
        if (lastFocused instanceof Fragment && iGuiEventListener != lastFocused) {
            ((Fragment)lastFocused).unfocus(iGuiEventListener);
        }
        this.focused = iGuiEventListener;
    }

    public void unfocus(@Nullable IGuiEventListener guiReplacing) {
        IGuiEventListener lastFocused = this.func_241217_q_();
        if (lastFocused instanceof Fragment && guiReplacing != lastFocused) {
            ((Fragment)lastFocused).unfocus(guiReplacing);
            this.func_231035_a_(null);
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.func_231037_b__(false);
        return this.func_241217_q_() != null && this.func_241217_q_().func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            boolean hasElement = super.func_231044_a_(mouseX, mouseY, button);
            if (!hasElement && this.func_241217_q_() instanceof Fragment) {
                this.func_231035_a_(null);
            }
            return true;
        }
        return false;
    }

    public void resize(Minecraft mc, int width, int height) {
    }

    @Override
    public int getLeft() {
        return ((Fragment)this.parentFragment).getLeft() + this.posX;
    }

    @Override
    public int getRight() {
        return ((Fragment)this.parentFragment).getLeft() + this.posX + this.width;
    }

    @Override
    public int getTop() {
        return ((Fragment)this.parentFragment).getTop() + this.posY;
    }

    @Override
    public int getBottom() {
        return ((Fragment)this.parentFragment).getTop() + this.posY + this.height;
    }

    @Override
    public void setPosX(int x) {
        this.posX = x;
    }

    @Override
    public void setPosY(int y) {
        this.posY = y;
    }

    @Override
    public void setLeft(int x) {
        this.posX = x - ((Fragment)this.parentFragment).getLeft();
    }

    @Override
    public void setRight(int x) {
        this.width = x - this.getLeft();
    }

    @Override
    public void setTop(int y) {
        this.posY = y - ((Fragment)this.parentFragment).getTop();
    }

    @Override
    public void setBottom(int y) {
        this.height = y - this.getTop();
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void expandX(int width) {
        if (this.width < width) {
            int lack = width - this.width;
            this.posX -= lack / 2 + lack % 2;
            this.width = width;
        }
    }

    @Override
    public void expandY(int height) {
        if (this.height < height) {
            int lack = height - this.height;
            this.posY -= lack / 2 + lack % 2;
            this.height = height;
        }
    }

    @Override
    public void contractX(int width) {
        if (this.width > width) {
            int lack = this.width - width;
            this.posX += lack / 2 + lack % 2;
            this.width = width;
        }
    }

    @Override
    public void contractY(int height) {
        if (this.height > height) {
            int lack = this.height - height;
            this.posY += lack / 2 + lack % 2;
            this.height = height;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getParentWidth() {
        return ((Fragment)this.parentFragment).getWidth();
    }

    @Override
    public int getParentHeight() {
        return ((Fragment)this.parentFragment).getHeight();
    }

    @Override
    public int getMinWidth() {
        return 1;
    }

    @Override
    public int getMinHeight() {
        return 1;
    }

    @Override
    public int getMaxWidth() {
        return 1000000;
    }

    @Override
    public int getMaxHeight() {
        return 1000000;
    }

    public static void bindTexture(ResourceLocation rl) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
    }
}

