/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.entity;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class LatchedEntity<M extends Entity>
extends Entity {
    private static final DataParameter<Integer> PARENT_ID = EntityDataManager.func_187226_a(LatchedEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public M parent;
    public UUID parentUUID;
    public int maxPersistAfterDeath = 0;
    public int timeAfterDeath = 0;

    public LatchedEntity(EntityType<?> type, World world) {
        super(type, world);
        this.func_82142_c(true);
    }

    public <T extends LatchedEntity> T setParent(@Nonnull M parent) {
        this.parent = parent;
        this.setParentId(parent.func_145782_y());
        this.func_70080_a(parent.func_226277_ct_(), parent.func_226278_cu_(), parent.func_226281_cx_(), ((Entity)parent).field_70177_z, ((Entity)parent).field_70125_A);
        this.field_213325_aI = ((Entity)parent).field_213325_aI;
        this.func_174826_a(parent.func_174813_aQ());
        return (T)((Object)this);
    }

    public <T extends LatchedEntity> T setPersistAfterDeath(int i) {
        this.maxPersistAfterDeath = i;
        return (T)((Object)this);
    }

    public void func_70088_a() {
        this.func_184212_Q().func_187214_a(PARENT_ID, (Object)-1);
    }

    public void setParentId(int i) {
        this.func_184212_Q().func_187227_b(PARENT_ID, (Object)i);
    }

    public int getParentId() {
        return (Integer)this.func_184212_Q().func_187225_a(PARENT_ID);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.parent == null) {
            if (this.parentUUID == null && this.getParentId() == -1) {
                this.unableToFindParent(false);
                return;
            }
            if (this.field_70173_aa % 5 != 1) return;
            Entity ent = this.field_70170_p.field_72995_K ? (this.getParentId() != -1 ? this.field_70170_p.func_73045_a(this.getParentId()) : null) : ((ServerWorld)this.field_70170_p).func_217461_a(this.parentUUID);
            if (ent != null) {
                this.setParent(ent);
                return;
            }
            if (this.field_70173_aa <= 201) return;
            this.unableToFindParent(true);
            return;
        }
        if (!this.parent.func_70089_S()) {
            if (this.maxPersistAfterDeath <= 0) {
                if (!((Entity)this.parent).field_70128_L) return;
                this.unableToFindParent(true);
                return;
            }
            if (this.timeAfterDeath >= this.maxPersistAfterDeath) {
                this.unableToFindParent(true);
                return;
            }
            ++this.timeAfterDeath;
            return;
        }
        if (!((Entity)this.parent).field_70170_p.func_234923_W_().equals(this.field_70170_p.func_234923_W_())) {
            this.parentDifferentDimension();
            return;
        }
        this.func_70107_b(this.parent.func_226277_ct_(), this.parent.func_226278_cu_(), this.parent.func_226281_cx_());
        this.func_70101_b(((Entity)this.parent).field_70177_z, ((Entity)this.parent).field_70125_A);
    }

    public void unableToFindParent(boolean hasId) {
        this.func_70106_y();
    }

    public void parentDifferentDimension() {
        this.unableToFindParent(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return this.parent != null ? this.parent.func_70112_a(distance) : super.func_70112_a(distance);
    }

    public float func_70013_c() {
        return this.parent != null ? this.parent.func_70013_c() : super.func_70013_c();
    }

    protected void func_70037_a(CompoundNBT tag) {
        this.parentUUID = tag.func_186857_a("parentUUID");
        this.setParentId(tag.func_74762_e("parentID"));
    }

    protected void func_213281_b(CompoundNBT tag) {
        tag.func_186854_a("parentUUID", this.parent.func_110124_au());
        tag.func_74768_a("parentID", this.getParentId());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

