/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.client.misc;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.block.BlockEnderTank;

@OnlyIn(value=Dist.CLIENT)
public class EventHandlerClient {
    private static Queue<String> queuedMessage = new ArrayDeque<String>();
    private static int timer;

    public static void setDelayedMessage(String message) {
        message = message.replace("<br>", "\u00c2\u00a6");
        String[] split = message.split("\u00c2\u00a6");
        queuedMessage.clear();
        timer = 0;
        queuedMessage.addAll(Arrays.asList(split));
    }

    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGameOverlayEvent event) {
        if (!queuedMessage.isEmpty() && event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR && --timer < 1) {
            timer = 175;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            String message = queuedMessage.poll();
            if (player != null && !Strings.isNullOrEmpty((String)message)) {
                player.func_146105_b((ITextComponent)new StringTextComponent(message), true);
            }
        }
    }

    @SubscribeEvent
    public void drawBlockHighlightEvent(DrawHighlightEvent.HighlightBlock event) {
        VoxelShape shape;
        BlockPos pos;
        if (event.getTarget() == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !player.func_213453_ef() || player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b()) {
            return;
        }
        World world = player.func_130014_f_();
        BlockState state = world.func_180495_p(pos = event.getTarget().func_216350_a());
        if (state.func_177230_c() instanceof BlockEnderTank && world.func_175723_af().func_177746_a(pos) && !(shape = this.getShapeToOutline((PlayerEntity)player, state, world, pos)).func_197766_b()) {
            this.drawSelectionBox(event.getMatrix(), event.getBuffers().getBuffer(RenderType.func_228659_m_()), event.getInfo(), pos, shape);
        }
    }

    private VoxelShape getShapeToOutline(PlayerEntity player, BlockState state, World world, BlockPos pos) {
        for (Hand hand : Hand.values()) {
            Item item = player.func_184586_b(hand).func_77973_b();
            if (Values.listPersonal.contains(item) || Values.listTeam.contains(item) || Values.listSmallCap_Single.contains(item) || Values.listSmallCap_Multi.contains(item) || Values.listLargeCap_Single.contains(item) || Values.listLargeCap_Multi.contains(item) || Values.listPump_Multi.contains(item) || Values.listPump_Single.contains(item)) {
                return state.func_196954_c((IBlockReader)world, pos);
            }
            if (!DyeHelper.isDye((Item)item) || BlockEnderTank.SHAPES.isEmpty()) continue;
            VoxelShape[] shapes = BlockEnderTank.SHAPES.get(state.func_177229_b((Property)BlockEnderTank.FACING));
            int subHit = Function.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])shapes);
            return subHit > 0 && subHit < 4 ? shapes[subHit] : VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_197880_a();
    }

    public void drawSelectionBox(MatrixStack matrixStack, IVertexBuilder buffer, ActiveRenderInfo info, BlockPos pos, VoxelShape shape) {
        double d0 = info.func_216785_c().field_72450_a;
        double d1 = info.func_216785_c().field_72448_b;
        double d2 = info.func_216785_c().field_72449_c;
        float mul = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        if (mul > 1.0f) {
            mul = 2.0f - mul;
        }
        EventHandlerClient.drawShape(matrixStack, buffer, shape, (double)pos.func_177958_n() - d0, (double)pos.func_177956_o() - d1, (double)pos.func_177952_p() - d2, 1.0f * mul, 1.0f * mul, 1.0f * mul, 0.4f);
    }

    private static void drawShape(MatrixStack matrixStack, IVertexBuilder buffer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        shape.func_197754_a((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer.func_227888_a_(matrix4f, (float)(minX + x), (float)(minY + y), (float)(minZ + z)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)(maxX + x), (float)(maxY + y), (float)(maxZ + z)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
    }
}

