/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;

public class EnderFluidHandlerItemStack
extends FluidHandlerItemStack {
    public EnderFluidHandlerItemStack(ItemStack stack) {
        super(stack, 0);
    }

    private EnderContainer getEnderContainer() {
        return TankHelper.getTank(StackHelper.getOwnerID(this.container), StackHelper.getCode(this.container), Thread.currentThread().getThreadGroup() == SidedThreadGroups.CLIENT);
    }

    public FluidStack getFluid() {
        IFluidHandler fluidTank = this.getEnderContainer().getTankFor(IFluidHandler.class);
        return fluidTank != null ? fluidTank.getFluidInTank(0) : FluidStack.EMPTY;
    }

    protected void setFluid(FluidStack fluid) {
        IFluidHandler fluidTank = this.getEnderContainer().getTankFor(IFluidHandler.class);
        if (fluidTank != null) {
            fluidTank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getEnderContainer().getCapacity();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.container.func_190916_E() != 1 || resource.isEmpty() || resource.getAmount() <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getEnderContainer().getCapacity(), resource.getAmount());
            if (doFill.execute()) {
                FluidStack filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getEnderContainer().getCapacity() - contained.getAmount(), resource.getAmount());
            if (doFill.execute() && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    protected void setContainerToEmpty() {
        IFluidHandler fluidTank = this.getEnderContainer().getTankFor(IFluidHandler.class);
        if (fluidTank != null) {
            fluidTank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

