/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class StackHelper {
    public static final String[] BASE_CODES = new String[]{"000", "111", "222", "333", "444", "555", "666", "777", "888", "999", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF"};

    public static ItemStack create(Item item, String code, String ownerID, @Nonnull ItemStack personalItem) {
        if (personalItem == null) {
            personalItem = ItemStack.field_190927_a;
        }
        ItemStack stack = StackHelper.create(item, code, !personalItem.func_190926_b() ? ownerID : "all");
        if (!personalItem.func_190926_b()) {
            String id = personalItem.func_77973_b().getRegistryName().toString();
            StackHelper.getTag(stack).func_74778_a("personal", id);
        }
        return stack;
    }

    public static ItemStack create(Item item, String code, String ownerID) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        StackHelper.setCode(stack, code);
        StackHelper.setOwner(stack, ownerID);
        return stack;
    }

    public static void setOwner(ItemStack stack, String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            ownerID = "all";
        }
        StackHelper.getTag(stack).func_74778_a("owner", ownerID);
    }

    private static void setCode(ItemStack stack, String code) {
        StackHelper.getTag(stack).func_74778_a("code", StackHelper.formatCode(code));
    }

    public static String getOwnerID(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (StackHelper.getTag(stack).func_74764_b("owner")) {
                return StackHelper.getTag(stack).func_74779_i("owner");
            }
            StackHelper.setOwner(stack, "all");
        }
        return "all";
    }

    public static String getOwnerName(ItemStack stack) {
        return TankInfoHelper.getDisplayNameFromOwnerID(StackHelper.getOwnerID(stack));
    }

    public static String getCode(ItemStack stack) {
        if (StackHelper.getTag(stack).func_74764_b("code")) {
            return StackHelper.formatCode(StackHelper.getTag(stack).func_74779_i("code"));
        }
        StackHelper.setCode(stack, "000");
        return "000";
    }

    @Nonnull
    public static ItemStack getPersonalItem(ItemStack stack) {
        String id = StackHelper.getTag(stack).func_74779_i("personal");
        if (!Strings.isNullOrEmpty((String)id)) {
            try {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
                if (item != null) {
                    return new ItemStack((IItemProvider)item, 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isPublic(ItemStack stack) {
        String ownerID = StackHelper.getOwnerID(stack);
        return Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all");
    }

    public static boolean isPrivate(ItemStack stack) {
        return !StackHelper.isPublic(stack) && !StackHelper.isTeam(stack);
    }

    public static boolean isTeam(ItemStack stack) {
        String ownerID = StackHelper.getOwnerID(stack);
        return !Strings.isNullOrEmpty((String)ownerID) && ownerID.startsWith("#");
    }

    private static CompoundNBT getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        return stack.func_77978_p();
    }

    private static String formatCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return "000";
        }
        if ((code = code.toUpperCase()).length() != 3) {
            while (code.length() < 3) {
                code = "0" + code;
            }
            code = code.substring(0, 3);
        }
        if (code.matches("[0-9A-F]{3}")) {
            return code;
        }
        char[] parts = code.toCharArray();
        for (int index = 0; index < 3; ++index) {
            if (!("" + parts[index]).matches("[^0-9A-F]")) continue;
            parts[index] = 48;
        }
        return "" + parts[0] + parts[1] + parts[2];
    }
}

