/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers.mekanism;

import java.util.Random;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shetiphian.core.client.Localization;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.modintegration.handlers.mekanism.WrapperGasHandler;

public class TypeGas {
    public static void init() {
        if (((Boolean)Configuration.INTEGRATION.storeMekanismGas.get()).booleanValue() && IGasHandler.class != null) {
            HandlerRegistry.register(Capabilities.GAS_HANDLER_CAPABILITY, GasTankHandler.Provider.INSTANCE);
        }
    }

    public static class GasTankHandler
    implements ITankHandler<IGasHandler> {
        private final ChemicalTankBuilder.BasicGasTank gasTank;
        private final IGasHandler gasTankInsertOnly;
        private final IGasHandler gasTankExtractOnly;
        private long tankCapacity;

        public GasTankHandler(final IEnderTankInfo tank) {
            this.tankCapacity = tank.getCapacity() * 1000;
            this.gasTank = new ChemicalTankBuilder.BasicGasTank(this.tankCapacity, (stack, type) -> true, (stack, type) -> true, stack -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, null){

                public long getCapacity() {
                    return tankCapacity;
                }

                public void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.gasTankInsertOnly = new WrapperGasHandler((IGasHandler)this.gasTank, true, false);
            this.gasTankExtractOnly = new WrapperGasHandler((IGasHandler)this.gasTank, false, true);
        }

        @Override
        public IGasHandler getTank(StorageAccessMode access) {
            switch (access) {
                case INSERT_ONLY: {
                    return this.gasTankInsertOnly;
                }
                case EXTRACT_ONLY: {
                    return this.gasTankExtractOnly;
                }
            }
            return this.gasTank;
        }

        @Override
        public void setCapacity(int capacity) {
            int newCapacity = capacity * 1000;
            if (this.tankCapacity != (long)newCapacity) {
                this.tankCapacity = newCapacity;
                this.gasTank.onContentsChanged();
            }
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.gasTank.deserializeNBT(nbt);
        }

        @Override
        public CompoundNBT save() {
            return !this.gasTank.isEmpty() ? this.gasTank.serializeNBT() : null;
        }

        @Override
        public String getContentsInfo() {
            GasStack stack = (GasStack)this.gasTank.getStack();
            if (!stack.isEmpty()) {
                return String.format(" %s %s [%sK/%sK mB]", Localization.get((String)"info.endertanks.tank.type.mekanism.gas.txt"), Localization.get((String)((Gas)stack.getType()).getTranslationKey()), Float.valueOf((float)stack.getAmount() / 1000.0f), this.gasTank.getCapacity() / 1000L);
            }
            return "";
        }

        @Override
        public void preformPumpAction(World world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, int pumpCapacity, Random random) {
            GasStack gasStack;
            long used;
            IGasHandler fromHandler = this.getHandler(world.func_175625_s(pullFromPos), facing);
            IGasHandler toHandler = this.getHandler(world.func_175625_s(pushToPos), facing.func_176734_d());
            if (fromHandler != null && (used = (gasStack = (GasStack)fromHandler.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((GasStack)this.gasTank.insertChemical((ChemicalStack)gasStack, Action.SIMULATE)).getAmount()) > 0L) {
                this.gasTank.insertChemical(fromHandler.extractChemical(used, Action.EXECUTE), Action.EXECUTE);
            }
            if (toHandler != null && (used = (gasStack = (GasStack)this.gasTank.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((GasStack)toHandler.insertChemical((ChemicalStack)gasStack, Action.SIMULATE)).getAmount()) > 0L) {
                toHandler.insertChemical(this.gasTank.extractChemical(used, Action.EXECUTE), Action.EXECUTE);
            }
        }

        public IGasHandler getHandler(TileEntity tile, Direction facing) {
            return tile == null ? null : (IGasHandler)tile.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, facing).orElse(null);
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<IGasHandler> {
            public static Provider INSTANCE = new Provider();

            @Override
            public ITankHandler<IGasHandler> create(IEnderTankInfo tank) {
                return new GasTankHandler(tank);
            }
        }
    }
}

