/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Potions;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockHummingbirdFeeder
extends Block {
    public static final IntegerProperty CONTENTS = IntegerProperty.func_177719_a((String)"contents", (int)0, (int)3);
    public static final BooleanProperty HANGING = BlockStateProperties.field_222514_j;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape AABB = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape AABB_HANGING = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BlockHummingbirdFeeder() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).harvestTool(ToolType.PICKAXE).func_200943_b(3.0f).func_200944_c().func_226896_b_());
        this.setRegistryName("alexsmobs:hummingbird_feeder");
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CONTENTS, (Comparable)Integer.valueOf(0))).func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)HANGING) != false ? AABB_HANGING : AABB;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate;
            if (direction.func_176740_k() != Direction.Axis.Y || !(blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        int contents = (Integer)state.func_177229_b((Property)CONTENTS);
        ItemStack waterBottle = AMEffectRegistry.createPotion(Potions.field_185230_b);
        ItemStack itemStack = player.func_184586_b(handIn);
        int setContent = -1;
        if (contents == 0) {
            if (itemStack.func_77973_b() == Items.field_151102_aT) {
                setContent = 2;
                this.useItem(player, itemStack);
            } else if (itemStack.func_77973_b() == waterBottle.func_77973_b() && ItemStack.func_77970_a((ItemStack)waterBottle, (ItemStack)itemStack)) {
                setContent = 1;
                this.useItem(player, itemStack);
            }
        } else if (contents == 1) {
            if (itemStack.func_77973_b() == Items.field_151102_aT) {
                setContent = 3;
                this.useItem(player, itemStack);
            }
        } else if (contents == 2 && itemStack.func_77973_b() == waterBottle.func_77973_b() && ItemStack.func_77970_a((ItemStack)waterBottle, (ItemStack)itemStack)) {
            setContent = 3;
            this.useItem(player, itemStack);
        }
        if (setContent >= 0) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)CONTENTS, (Comparable)Integer.valueOf(setContent)));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void useItem(PlayerEntity playerEntity, ItemStack stack) {
        if (!playerEntity.func_184812_l_()) {
            if (stack.hasContainerItem()) {
                playerEntity.func_191521_c(stack.getContainerItem().func_77946_l());
            }
            stack.func_190918_g(1);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = BlockHummingbirdFeeder.getBlockConnected(state).func_176734_d();
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return BlockHummingbirdFeeder.getBlockConnected(stateIn).func_176734_d() == facing && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONTENTS, HANGING, WATERLOGGED});
    }
}

