/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OctopusColorRegistry {
    public static final BlockState FALLBACK_BLOCK = Blocks.field_150354_m.func_176223_P();
    public static Map<String, Integer> TEXTURES_TO_COLOR = new HashMap<String, Integer>();

    public static int getBlockColor(BlockState stack) {
        String blockName = stack.toString();
        if (TEXTURES_TO_COLOR.get(blockName) != null) {
            return TEXTURES_TO_COLOR.get(blockName);
        }
        int colorizer = -1;
        try {
            colorizer = Minecraft.func_71410_x().func_184125_al().func_228054_a_(stack, null, null, 0);
        }
        catch (Exception e) {
            AlexsMobs.LOGGER.warn("Another mod did not use block colorizers correctly.");
        }
        int color = 0xFFFFFF;
        if (colorizer == -1) {
            Object texture = null;
            try {
                Color texColour = OctopusColorRegistry.getAverageColour(OctopusColorRegistry.getTextureAtlas(stack));
                color = texColour.getRGB();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            color = colorizer;
        }
        TEXTURES_TO_COLOR.put(blockName, color);
        return color;
    }

    private static Color getAverageColour(TextureAtlasSprite image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        int uMax = image.func_94211_a();
        int vMax = image.func_94216_b();
        for (float i = 0.0f; i < (float)uMax; i += 1.0f) {
            for (float j = 0.0f; j < (float)vMax; j += 1.0f) {
                int alpha = image.getPixelRGBA(0, (int)i, (int)j) >> 24 & 0xFF;
                if (alpha == 0) continue;
                red += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 0 & 0xFF);
                green += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 8 & 0xFF);
                blue += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 16 & 0xFF);
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static TextureAtlasSprite getTextureAtlas(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state).func_177554_e();
    }
}

