/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelTiger;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerTigerEyes;
import com.github.alexthe666.alexsmobs.entity.EntityTiger;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class RenderTiger
extends MobRenderer<EntityTiger, ModelTiger> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexsmobs:textures/entity/tiger/tiger.png");
    private static final ResourceLocation TEXTURE_ANGRY = new ResourceLocation("alexsmobs:textures/entity/tiger/tiger_angry.png");
    private static final ResourceLocation TEXTURE_SLEEPING = new ResourceLocation("alexsmobs:textures/entity/tiger/tiger_sleeping.png");
    private static final ResourceLocation TEXTURE_WHITE = new ResourceLocation("alexsmobs:textures/entity/tiger/tiger_white.png");
    private static final ResourceLocation TEXTURE_ANGRY_WHITE = new ResourceLocation("alexsmobs:textures/entity/tiger/tiger_white_angry.png");
    private static final ResourceLocation TEXTURE_SLEEPING_WHITE = new ResourceLocation("alexsmobs:textures/entity/tiger/tiger_white_sleeping.png");

    public RenderTiger(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelTiger(), 0.6f);
        this.func_177094_a(new LayerTigerEyes(this));
    }

    protected void preRenderCallback(EntityTiger entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
    }

    public void render(EntityTiger entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Direction direction;
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)entityIn, (LivingRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn))) {
            return;
        }
        matrixStackIn.func_227860_a_();
        ((ModelTiger)this.field_77045_g).field_217112_c = this.func_77040_d((LivingEntity)entityIn, partialTicks);
        ((ModelTiger)this.field_77045_g).field_217113_d = shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
        ((ModelTiger)this.field_77045_g).field_217114_e = entityIn.func_70631_g_();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70758_at, (float)entityIn.field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && entityIn.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_70127_C, (float)entityIn.field_70125_A);
        if (entityIn.func_213283_Z() == Pose.SLEEPING && (direction = entityIn.func_213376_dz()) != null) {
            float f4 = entityIn.func_213307_e(Pose.STANDING) - 0.1f;
            matrixStackIn.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = this.func_77044_a((LivingEntity)entityIn, partialTicks);
        this.func_225621_a_((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.preRenderCallback(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_184618_aE, (float)entityIn.field_70721_aZ);
            f5 = entityIn.field_184619_aG - entityIn.field_70721_aZ * (1.0f - partialTicks);
            if (entityIn.func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((ModelTiger)this.field_77045_g).func_212843_a_((Entity)entityIn, f5, f8, partialTicks);
        ((ModelTiger)this.field_77045_g).setRotationAngles(entityIn, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean flag = this.func_225622_a_((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.func_98034_c((PlayerEntity)minecraft.field_71439_g);
        boolean flag2 = minecraft.func_238206_b_((Entity)entityIn);
        RenderType rendertype = this.func_230496_a_(entityIn, flag, flag1, flag2);
        if (rendertype != null) {
            float stealthLevel = entityIn.prevStealthProgress + (entityIn.stealthProgress - entityIn.prevStealthProgress) * partialTicks;
            this.field_76989_e = 0.6f * (1.0f - stealthLevel * 0.1f);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(rendertype);
            int i = RenderTiger.func_229117_c_((LivingEntity)entityIn, (float)this.func_225625_b_((LivingEntity)entityIn, partialTicks));
            ((ModelTiger)this.field_77045_g).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : MathHelper.func_76131_a((float)(1.0f - stealthLevel * 0.1f), (float)0.0f, (float)1.0f));
        }
        if (!entityIn.func_175149_v()) {
            for (LayerRenderer layerrenderer : this.field_177097_h) {
                layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.func_227865_b_();
        Entity entity = entityIn.func_110166_bE();
        if (entity != null) {
            this.renderLeash(entityIn, partialTicks, matrixStackIn, bufferIn, entity);
        }
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)entityIn, entityIn.func_145748_c_(), (EntityRenderer)this, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.func_177070_b((MobEntity)entityIn))) {
            this.func_225629_a_((Entity)entityIn, renderNameplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)entityIn, (LivingRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn));
    }

    private <E extends Entity> void renderLeash(EntityTiger entityLivingIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, E leashHolder) {
        matrixStackIn.func_227860_a_();
        Vector3d vector3d = leashHolder.func_241843_o(partialTicks);
        double d0 = (double)(MathHelper.func_219799_g((float)partialTicks, (float)entityLivingIn.field_70761_aq, (float)entityLivingIn.field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vector3d1 = entityLivingIn.func_241205_ce_();
        double d1 = Math.cos(d0) * vector3d1.field_72449_c + Math.sin(d0) * vector3d1.field_72450_a;
        double d2 = Math.sin(d0) * vector3d1.field_72449_c - Math.cos(d0) * vector3d1.field_72450_a;
        double d3 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70169_q, (double)entityLivingIn.func_226277_ct_()) + d1;
        double d4 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70167_r, (double)entityLivingIn.func_226278_cu_()) + vector3d1.field_72448_b;
        double d5 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70166_s, (double)entityLivingIn.func_226281_cx_()) + d2;
        matrixStackIn.func_227861_a_(d1, vector3d1.field_72448_b, d2);
        float f = (float)(vector3d.field_72450_a - d3);
        float f1 = (float)(vector3d.field_72448_b - d4);
        float f2 = (float)(vector3d.field_72449_c - d5);
        float f3 = 0.025f;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float f4 = MathHelper.func_226165_i_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(entityLivingIn.func_174824_e(partialTicks));
        BlockPos blockpos1 = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int i = this.func_225624_a_((Entity)entityLivingIn, blockpos);
        int j = this.getBlockLight2(leashHolder, blockpos1);
        int k = entityLivingIn.field_70170_p.func_226658_a_(LightType.SKY, blockpos);
        int l = entityLivingIn.field_70170_p.func_226658_a_(LightType.SKY, blockpos1);
        RenderTiger.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.025f, (float)f5, (float)f6);
        RenderTiger.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.0f, (float)f5, (float)f6);
        matrixStackIn.func_227865_b_();
    }

    protected int getBlockLight2(Entity entityIn, BlockPos partialTicks) {
        return entityIn.func_70027_ad() ? 15 : entityIn.field_70170_p.func_226658_a_(LightType.BLOCK, partialTicks);
    }

    @Nullable
    protected RenderType func_230496_a_(EntityTiger tiger, boolean b0, boolean b1, boolean b2) {
        if (tiger.isStealth()) {
            ResourceLocation resourcelocation = this.getEntityTexture(tiger);
            return RenderType.func_239268_f_((ResourceLocation)resourcelocation);
        }
        return super.func_230496_a_((LivingEntity)tiger, b0, b1, b2);
    }

    public ResourceLocation getEntityTexture(EntityTiger entity) {
        if (entity.func_70608_bn()) {
            return entity.isWhite() ? TEXTURE_SLEEPING_WHITE : TEXTURE_SLEEPING;
        }
        if (entity.func_230256_F__() > 0) {
            return entity.isWhite() ? TEXTURE_ANGRY_WHITE : TEXTURE_ANGRY;
        }
        return entity.isWhite() ? TEXTURE_WHITE : TEXTURE;
    }
}

