/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityGorilla;
import com.github.alexthe666.alexsmobs.entity.EntityTossedItem;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CapuchinAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.CapuchinAIRangedAttack;
import com.github.alexthe666.alexsmobs.entity.ai.CapuchinAITargetBalloons;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIFollowOwner;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityCapuchinMonkey
extends TameableEntity
implements IAnimatedEntity,
IFollower,
ITargetsDroppedItems {
    public static final Animation ANIMATION_THROW = Animation.create((int)12);
    public static final Animation ANIMATION_HEADTILT = Animation.create((int)15);
    public static final Animation ANIMATION_SCRATCH = Animation.create((int)20);
    protected static final DataParameter<Boolean> DART = EntityDataManager.func_187226_a(EntityCapuchinMonkey.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityCapuchinMonkey.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityCapuchinMonkey.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DART_TARGET = EntityDataManager.func_187226_a(EntityCapuchinMonkey.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float prevSitProgress;
    public float sitProgress;
    public boolean forcedSit = false;
    public boolean attackDecision = false;
    private int animationTick;
    private Animation currentAnimation;
    private int sittingTime = 0;
    private int maxSitTime = 75;
    private Ingredient temptationItems = Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(ItemTags.func_199903_a().func_199910_a(AMTagRegistry.INSECT_ITEMS)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151110_aK))));
    private boolean hasSlowed = false;
    private int rideCooldown = 0;

    protected EntityCapuchinMonkey(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.LEAVES, 0.0f);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.4f);
    }

    public static <T extends MobEntity> boolean canCapuchinSpawn(EntityType<EntityCapuchinMonkey> gorilla, IWorld worldIn, SpawnReason reason, BlockPos p_223317_3_, Random random) {
        BlockState blockstate = worldIn.func_180495_p(p_223317_3_.func_177977_b());
        return (blockstate.func_235714_a_((ITag)BlockTags.field_206952_E) || blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_235714_a_((ITag)BlockTags.field_200031_h) || blockstate.func_203425_a(Blocks.field_150350_a)) && worldIn.func_226659_b_(p_223317_3_, 0) > 8;
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.capuchinMonkeySpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 4.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new CapuchinAIMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new CapuchinAIRangedAttack(this, 1.0, 20, 15.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new TameableAIFollowOwner(this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.merge((Collection)ImmutableList.of((Object)Ingredient.func_199805_a((ITag)ItemTags.func_199903_a().func_199910_a(AMTagRegistry.BANANAS)))), true){

            public void func_75246_d() {
                super.func_75246_d();
                if (this.field_75284_a.func_70068_e((Entity)this.field_75289_h) < 6.25 && this.field_75284_a.func_70681_au().nextInt(14) == 0) {
                    ((EntityCapuchinMonkey)this.field_75284_a).setAnimation(ANIMATION_HEADTILT);
                }
            }
        });
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 60));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new CreatureAITargetItems((CreatureEntity)this, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityCapuchinMonkey.class, EntityTossedItem.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new CapuchinAITargetBalloons(this, true));
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.CAPUCHIN_MONKEY_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.CAPUCHIN_MONKEY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.CAPUCHIN_MONKEY_HURT;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("MonkeySitting", this.isSitting());
        compound.func_74757_a("HasDart", this.hasDart());
        compound.func_74757_a("ForcedToSit", this.forcedSit);
        compound.func_74768_a("Command", this.getCommand());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_233687_w_(compound.func_74767_n("MonkeySitting"));
        this.forcedSit = compound.func_74767_n("ForcedToSit");
        this.setCommand(compound.func_74762_e("Command"));
        this.setDart(compound.func_74767_n("HasDart"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevSitProgress = this.sitProgress;
        if (this.isSitting() && this.sitProgress < 10.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isSitting() && !this.forcedSit && ++this.sittingTime > this.maxSitTime) {
            this.func_233687_w_(false);
            this.sittingTime = 0;
            this.maxSitTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION && !this.isSitting() && this.getCommand() != 1 && this.field_70146_Z.nextInt(1500) == 0) {
            this.maxSitTime = 300 + this.field_70146_Z.nextInt(250);
            this.func_233687_w_(true);
        }
        this.field_70138_W = 2.0f;
        if (!this.forcedSit && this.isSitting() && (this.getDartTarget() != null || this.getCommand() == 1)) {
            this.func_233687_w_(false);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.getAnimation() == ANIMATION_SCRATCH && this.getAnimationTick() == 10) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * 0.3f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * 0.3f)));
            this.func_70638_az().func_233627_a_(1.0f, this.func_70638_az().func_226277_ct_() - this.func_226277_ct_(), this.func_70638_az().func_226281_cx_() - this.func_226281_cx_());
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
            this.setAttackDecision((Entity)this.func_70638_az());
        }
        if (!this.field_70170_p.field_72995_K && this.getDartTarget() != null && this.getDartTarget().func_70089_S() && this.getAnimation() == ANIMATION_THROW && this.getAnimationTick() == 5) {
            Vector3d vector3d = this.getDartTarget().func_213322_ci();
            double d0 = this.getDartTarget().func_226277_ct_() + vector3d.field_72450_a - this.func_226277_ct_();
            double d1 = this.getDartTarget().func_226280_cw_() - (double)1.1f - this.func_226278_cu_();
            double d2 = this.getDartTarget().func_226281_cx_() + vector3d.field_72449_c - this.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            EntityTossedItem tossedItem = new EntityTossedItem(this.field_70170_p, (LivingEntity)this);
            tossedItem.setDart(this.hasDart());
            tossedItem.field_70125_A -= -20.0f;
            tossedItem.func_70186_c(d0, d1 + (double)(f * 0.2f), d2, this.hasDart() ? 1.15f : 0.75f, 8.0f);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            }
            this.field_70170_p.func_217376_c((Entity)tossedItem);
            this.setAttackDecision(this.getDartTarget());
        }
        if (this.rideCooldown > 0) {
            --this.rideCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION && this.func_70681_au().nextInt(300) == 0) {
            this.setAnimation(ANIMATION_HEADTILT);
        }
        if (!this.field_70170_p.field_72995_K && this.isSitting()) {
            this.func_70661_as().func_75499_g();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SCRATCH);
        }
        return true;
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.isSitting()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.hasDart()) {
            this.func_199703_a((IItemProvider)AMItemRegistry.ANCIENT_DART);
        }
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && !entity.func_70089_S()) {
            this.func_184210_p();
        } else if (this.func_70909_n() && entity instanceof LivingEntity && this.func_152114_e((LivingEntity)entity)) {
            Entity mount;
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70071_h_();
            if (this.func_184218_aH() && (mount = this.func_184187_bx()) instanceof PlayerEntity) {
                this.field_70761_aq = ((LivingEntity)mount).field_70761_aq;
                this.field_70177_z = ((LivingEntity)mount).field_70177_z;
                this.field_70759_as = ((LivingEntity)mount).field_70759_as;
                this.field_70126_B = ((LivingEntity)mount).field_70759_as;
                float radius = 0.0f;
                float angle = (float)Math.PI / 180 * (((LivingEntity)mount).field_70761_aq - 180.0f);
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                this.func_70107_b(mount.func_226277_ct_() + extraX, Math.max(mount.func_226278_cu_() + (double)mount.func_213302_cg() + 0.1, mount.func_226278_cu_()), mount.func_226281_cx_() + extraZ);
                this.attackDecision = true;
                if (!mount.func_70089_S() || this.rideCooldown == 0 && mount.func_225608_bj_()) {
                    this.func_233575_bb_();
                    this.attackDecision = false;
                }
            }
        } else {
            super.func_70098_U();
        }
    }

    public void setAttackDecision(Entity target) {
        this.attackDecision = target instanceof MonsterEntity || this.hasDart() ? true : !this.attackDecision;
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void func_233687_w_(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean hasDartTarget() {
        return (Integer)this.field_70180_af.func_187225_a(DART_TARGET) != -1 && this.hasDart();
    }

    public void setDartTarget(Entity entity) {
        this.field_70180_af.func_187227_b(DART_TARGET, (Object)(entity == null ? -1 : entity.func_145782_y()));
        if (entity instanceof LivingEntity) {
            this.func_70624_b((LivingEntity)entity);
        }
    }

    @Nullable
    public Entity getDartTarget() {
        if (!this.hasDartTarget()) {
            return this.func_70638_az();
        }
        Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(DART_TARGET)).intValue());
        if (entity == null || !entity.func_70089_S()) {
            return this.func_70638_az();
        }
        return entity;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(DART_TARGET, (Object)-1);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(DART, (Object)false);
    }

    public boolean hasDart() {
        return (Boolean)this.field_70180_af.func_187225_a(DART);
    }

    public void setDart(boolean dart) {
        this.field_70180_af.func_187227_b(DART, (Object)dart);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.CAPUCHIN_MONKEY.func_200721_a((World)p_241840_1_);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || super.func_180431_b(source);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (!this.func_70909_n() && EntityGorilla.isBanana(itemstack)) {
            this.func_175505_a(player, itemstack);
            if (this.func_70681_au().nextInt(5) == 0) {
                this.func_193101_c(player);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && (EntityGorilla.isBanana(itemstack) || this.temptationItems.test(itemstack) && !this.func_70877_b(itemstack)) && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_175505_a(player, itemstack);
            this.func_184185_a(SoundEvents.field_219607_aG, this.func_70599_aP(), this.func_70647_i());
            this.func_70691_i(5.0f);
            return ActionResultType.SUCCESS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70877_b(itemstack) && !EntityGorilla.isBanana(itemstack) && !this.temptationItems.test(itemstack)) {
            boolean sit;
            if (!this.hasDart() && itemstack.func_77973_b() == AMItemRegistry.ANCIENT_DART) {
                this.setDart(true);
                this.func_175505_a(player, itemstack);
                return ActionResultType.CONSUME;
            }
            if (this.hasDart() && itemstack.func_77973_b() == Items.field_151097_aZ) {
                this.setDart(false);
                itemstack.func_222118_a(1, (LivingEntity)this, p_233654_0_ -> {});
                return ActionResultType.SUCCESS;
            }
            if (player.func_225608_bj_() && player.func_184188_bt().isEmpty()) {
                this.func_184220_m((Entity)player);
                this.rideCooldown = 20;
                return ActionResultType.SUCCESS;
            }
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.forcedSit = true;
                this.func_233687_w_(true);
                return ActionResultType.SUCCESS;
            }
            this.forcedSit = false;
            this.func_233687_w_(false);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_THROW, ANIMATION_SCRATCH};
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return this.temptationItems.test(stack) || EntityGorilla.isBanana(stack);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.func_70909_n() && ItemTags.func_199903_a().func_199910_a(AMTagRegistry.INSECT_ITEMS).func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.func_70691_i(5.0f);
        this.func_184185_a(SoundEvents.field_219607_aG, this.func_70599_aP(), this.func_70647_i());
        if (EntityGorilla.isBanana(e.func_92059_d())) {
            if (this.func_70681_au().nextInt(4) == 0) {
                this.func_199701_a_(new ItemStack((IItemProvider)AMBlockRegistry.BANANA_PEEL));
            }
            if (e.func_200214_m() != null && !this.func_70909_n()) {
                if (this.func_70681_au().nextInt(5) == 0) {
                    this.func_70903_f(true);
                    this.func_184754_b(e.func_200214_m());
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
        }
    }
}

