/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.IHurtableMultipart;
import com.github.alexthe666.alexsmobs.message.MessageHurtMultipart;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityCentipedeBody
extends MobEntity
implements IHurtableMultipart {
    private static final DataParameter<Integer> BODYINDEX = EntityDataManager.func_187226_a(EntityCentipedeBody.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> PARENT_UUID = EntityDataManager.func_187226_a(EntityCentipedeBody.class, (IDataSerializer)DataSerializers.field_187203_m);
    public EntitySize multipartSize;
    protected float radius;
    protected float angleYaw;
    protected float offsetY;
    protected float damageMultiplier = 1.0f;
    private float parentYaw = 0.0f;

    protected EntityCentipedeBody(EntityType type, World worldIn) {
        super(type, worldIn);
        this.multipartSize = type.func_220334_j();
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.getParent() != null;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || super.func_180431_b(source);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_71087_bX = false;
        Entity parent = this.getParent();
        this.func_213323_x_();
        if (parent != null && !this.field_70170_p.field_72995_K) {
            float f = this.func_70032_d(parent);
            this.func_189654_d(true);
            this.func_70625_a(parent, 1.0f, 1.0f);
            this.parentYaw = this.limitAngle(this.parentYaw, parent.field_70126_B, 5.0f);
            double yD1 = (parent.func_226278_cu_() - this.func_226278_cu_()) / (double)f;
            double ySet = parent.field_70167_r;
            if (!this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), ySet - 0.1, this.func_226281_cx_())).func_200132_m()) {
                ySet = parent.field_70167_r - (double)0.2f;
            }
            if (this.func_70094_T() || this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), ySet, this.func_226281_cx_())).func_200132_m()) {
                ySet = parent.field_70167_r + (double)0.2f;
            }
            double yaw = this.parentYaw;
            double x = parent.field_70169_q + (double)this.radius * Math.cos(yaw * (Math.PI / 180) + (double)this.angleYaw);
            double z = parent.field_70166_s + (double)this.radius * Math.sin(yaw * (Math.PI / 180) + (double)this.angleYaw);
            this.func_70107_b(x, ySet, z);
            double d0 = parent.func_226277_ct_() - this.func_226277_ct_();
            double d1 = parent.func_226278_cu_() - this.func_226278_cu_();
            double d2 = parent.func_226281_cx_() - this.func_226281_cx_();
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
            this.field_70125_A = this.limitAngle(this.field_70125_A, f2, 5.0f);
            this.func_70018_K();
            this.field_70759_as = this.field_70177_z = this.parentYaw;
            this.field_70761_aq = this.field_70126_B;
            if (parent instanceof LivingEntity && !this.field_70170_p.field_72995_K && (((LivingEntity)parent).field_70737_aN > 0 || ((LivingEntity)parent).field_70725_aQ > 0)) {
                AlexsMobs.sendMSGToAll(new MessageHurtMultipart(this.func_145782_y(), parent.func_145782_y(), 0.0f));
                this.field_70737_aN = ((LivingEntity)parent).field_70737_aN;
                this.field_70725_aQ = ((LivingEntity)parent).field_70725_aQ;
            }
            this.func_85033_bc();
            if (parent.field_70128_L && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
        if (parent == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected float limitAngle(float sourceAngle, float targetAngle, float maximumChange) {
        float f1;
        float f = MathHelper.func_76142_g((float)(targetAngle - sourceAngle));
        if (f > maximumChange) {
            f = maximumChange;
        }
        if (f < -maximumChange) {
            f = -maximumChange;
        }
        if ((f1 = sourceAngle + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public void setInitialPartPos(LivingEntity parent, int index) {
        double radAdd = this.radius * (float)index;
        this.field_70177_z = parent.field_70177_z;
        this.field_70761_aq = parent.field_70761_aq;
        this.parentYaw = parent.field_70177_z;
        this.func_70107_b(parent.field_70169_q + radAdd * Math.cos((double)parent.field_70177_z * (Math.PI / 180) + (double)this.angleYaw), parent.field_70167_r + (double)this.offsetY, parent.field_70166_s + radAdd * Math.sin((double)parent.field_70177_z * (Math.PI / 180) + (double)this.angleYaw));
    }

    public EntityCentipedeBody(EntityType t, LivingEntity parent, float radius, float angleYaw, float offsetY) {
        super(t, parent.field_70170_p);
        this.setParent((Entity)parent);
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getParentId() != null) {
            compound.func_186854_a("ParentUUID", this.getParentId());
        }
        compound.func_74768_a("BodyIndex", this.getBodyIndex());
        compound.func_74776_a("PartAngle", this.angleYaw);
        compound.func_74776_a("PartRadius", this.radius);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("ParentUUID")) {
            this.setParentId(compound.func_186857_a("ParentUUID"));
        }
        this.setBodyIndex(compound.func_74762_e("BodyIndex"));
        this.angleYaw = compound.func_74760_g("PartAngle");
        this.radius = compound.func_74760_g("PartRadius");
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PARENT_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(BODYINDEX, (Object)0);
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.func_110124_au());
    }

    public boolean func_70028_i(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean prev;
        Entity parent = this.getParent();
        boolean bl = prev = parent != null && parent.func_70097_a(source, damage * this.damageMultiplier);
        if (prev && !this.field_70170_p.field_72995_K) {
            AlexsMobs.sendMSGToAll(new MessageHurtMultipart(this.func_145782_y(), parent.func_145782_y(), damage * this.damageMultiplier));
        }
        return prev;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_85033_bc() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        Entity parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(entity -> entity != parent && !(entity instanceof EntityCentipedeBody) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f(parent));
        }
    }

    public boolean func_184220_m(Entity entityIn) {
        if (!(entityIn instanceof AbstractMinecartEntity) && !(entityIn instanceof BoatEntity)) {
            return super.func_184220_m(entityIn);
        }
        return false;
    }

    public int getBodyIndex() {
        return (Integer)this.field_70180_af.func_187225_a(BODYINDEX);
    }

    public void setBodyIndex(int index) {
        this.field_70180_af.func_187227_b(BODYINDEX, (Object)index);
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.field_70180_af.func_187225_a(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Override
    public void onAttackedFromServer(LivingEntity parent, float damage) {
        if (parent.field_70725_aQ > 0) {
            this.field_70725_aQ = parent.field_70725_aQ;
        }
        if (parent.field_70737_aN > 0) {
            this.field_70737_aN = parent.field_70737_aN;
        }
    }
}

