/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.message;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.EntityMungus;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageMungusBiomeChange {
    public int mungusID;
    public int posX;
    public int posZ;
    public String biomeOption;

    public MessageMungusBiomeChange(int mungusID, int posX, int posY, String biomeOption) {
        this.mungusID = mungusID;
        this.posX = posX;
        this.posZ = posY;
        this.biomeOption = biomeOption;
    }

    public MessageMungusBiomeChange() {
    }

    public static MessageMungusBiomeChange read(PacketBuffer buf) {
        return new MessageMungusBiomeChange(buf.readInt(), buf.readInt(), buf.readInt(), buf.func_218666_n());
    }

    public static void write(MessageMungusBiomeChange message, PacketBuffer buf) {
        buf.writeInt(message.mungusID);
        buf.writeInt(message.posX);
        buf.writeInt(message.posZ);
        buf.func_180714_a(message.biomeOption);
    }

    public static class Handler {
        public static void handle(MessageMungusBiomeChange message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = AlexsMobs.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null) {
                Entity entity = player.field_70170_p.func_73045_a(message.mungusID);
                MutableRegistry registry = player.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_);
                Biome biome = (Biome)registry.func_82594_a(new ResourceLocation(message.biomeOption));
                if (AMConfig.mungusBiomeTransformationType == 2 && entity instanceof EntityMungus && entity.func_70092_e((double)message.posX, entity.func_226278_cu_(), (double)message.posZ) < 1000.0 && biome != null) {
                    Chunk chunk = player.field_70170_p.func_175726_f(new BlockPos(message.posX, 0, message.posZ));
                    BiomeContainer container = chunk.func_225549_i_();
                    if (container != null) {
                        for (int i = 0; i < container.field_227054_f_.length; ++i) {
                            container.field_227054_f_[i] = biome;
                        }
                    }
                    AlexsMobs.PROXY.updateBiomeVisuals(message.posX, message.posZ);
                }
            }
        }
    }
}

