/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.FileUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiTransfer;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.gui.MyBigButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class GuiWaypointsOptions
extends ScreenBase {
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private Button automaticButton;
    private Button subAutomaticButton;
    private Button deleteButton;
    private Button subDeleteButton;
    private Button connectButton;
    private boolean buttonTest;
    private WaypointWorld waypointWorld;
    private WaypointWorld automaticWaypointWorld;
    private WaypointWorldRootContainer rootContainer;
    private boolean teleportationOptionShown;
    private boolean selectedWorldIsConnected;
    public CursorBox mwTooltip = new CursorBox("gui.xaero_use_multiworld_tooltip");
    public CursorBox teleportationTooltip = new CursorBox("gui.xaero_teleportation_tooltip", Style.field_240709_b_.func_240712_a_(TextFormatting.RED));
    public CursorBox connectionTooltip = new CursorBox("gui.xaero_world_connection_tooltip");

    public GuiWaypointsOptions(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen parent, Screen escapeScreen, WaypointWorld waypointWorld, String frozenAutoContainerID, String frozenAutoWorldID) {
        super(modMain, parent, escapeScreen, (ITextComponent)new TranslationTextComponent("gui.xaero_options"));
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.waypointWorld = waypointWorld;
        this.rootContainer = waypointWorld.getContainer().getRootContainer();
        this.automaticWaypointWorld = this.waypointsManager.getWorld(frozenAutoContainerID, frozenAutoWorldID);
        this.teleportationOptionShown = this.rootContainer.isTeleportationEnabled();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.parent.func_231152_a_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        this.selectedWorldIsConnected = this.rootContainer.getSubWorldConnections().isConnected(this.automaticWaypointWorld, this.waypointWorld);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 203, 32, (ITextComponent)new TranslationTextComponent("gui.xaero_close", new Object[0]), b -> this.actionPerformed(b, 5)));
        this.func_230480_a_((Widget)new MyBigButton(6, this.field_230708_k_ / 2 - 203, 57, (ITextComponent)new TranslationTextComponent("gui.xaero_transfer", new Object[0]), b -> this.actionPerformed(b, 6)));
        this.automaticButton = new MyBigButton(7, this.field_230708_k_ / 2 - 203, 82, (ITextComponent)new TranslationTextComponent("gui.xaero_make_automatic", new Object[0]), b -> this.actionPerformed(b, 7));
        this.func_230480_a_((Widget)this.automaticButton);
        this.subAutomaticButton = new MyBigButton(8, this.field_230708_k_ / 2 - 203, 107, (ITextComponent)new TranslationTextComponent("gui.xaero_make_multi_automatic", new Object[0]), b -> this.actionPerformed(b, 8));
        this.func_230480_a_((Widget)this.subAutomaticButton);
        this.deleteButton = new MyBigButton(9, this.field_230708_k_ / 2 - 203, 132, (ITextComponent)new TranslationTextComponent("gui.xaero_delete_world", new Object[0]), b -> this.actionPerformed(b, 9));
        this.func_230480_a_((Widget)this.deleteButton);
        this.subDeleteButton = new MyBigButton(10, this.field_230708_k_ / 2 - 203, 157, (ITextComponent)new TranslationTextComponent("gui.xaero_delete_multi_world", new Object[0]), b -> this.actionPerformed(b, 10));
        this.func_230480_a_((Widget)this.subDeleteButton);
        this.func_230480_a_((Widget)new MyBigButton(200, this.field_230708_k_ / 2 + 3, 57, (ITextComponent)new StringTextComponent(this.getConfigButtonName(0)), b -> this.onConfigButtonClick((MyBigButton)b)));
        MyBigButton teleportationEnabledButton = (MyBigButton)this.func_230480_a_((Widget)new MyBigButton(201, this.field_230708_k_ / 2 + 3, 82, (ITextComponent)new StringTextComponent(this.getConfigButtonName(1)), b -> this.onConfigButtonClick((MyBigButton)b)));
        teleportationEnabledButton.field_230693_o_ = this.teleportationOptionShown;
        this.func_230480_a_((Widget)new MyBigButton(13, this.field_230708_k_ / 2 + 3, 107, (ITextComponent)new TranslationTextComponent("gui.xaero_world_teleport_command"), b -> this.actionPerformed(b, 13)));
        this.connectButton = new MyBigButton(14, this.field_230708_k_ / 2 + 3, 132, (ITextComponent)new StringTextComponent(this.getConfigButtonName(4)), b -> this.actionPerformed(b, 14));
        this.func_230480_a_((Widget)this.connectButton);
        this.connectButton.field_230693_o_ = this.waypointsManager.isMultiplayer(this.rootContainer.getKey()) && this.waypointWorld.getContainer() != this.automaticWaypointWorld.getContainer() && this.rootContainer == this.automaticWaypointWorld.getContainer().getRootContainer();
        this.func_230480_a_((Widget)new MyBigButton(202, this.field_230708_k_ / 2 + 3, 182, (ITextComponent)new StringTextComponent(this.getConfigButtonName(2)), b -> this.onConfigButtonClick((MyBigButton)b)));
        this.func_230480_a_((Widget)new MyBigButton(203, this.field_230708_k_ / 2 + 3, 207, (ITextComponent)new StringTextComponent(this.getConfigButtonName(3)), b -> this.onConfigButtonClick((MyBigButton)b)));
    }

    private String getConfigButtonName(int buttonId) {
        switch (buttonId) {
            case 0: {
                return I18n.func_135052_a((String)"gui.xaero_use_multiworld", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isUsingMultiworldDetection());
            }
            case 1: {
                return I18n.func_135052_a((String)"gui.xaero_teleportation", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isTeleportationEnabled());
            }
            case 2: {
                return I18n.func_135052_a((String)"gui.xaero_sort", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)this.rootContainer.getSortType().optionName, (Object[])new Object[0]);
            }
            case 3: {
                return I18n.func_135052_a((String)"gui.xaero_sort_reversed", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isSortReversed());
            }
            case 4: {
                return this.selectedWorldIsConnected ? I18n.func_135052_a((String)"gui.xaero_disconnect_from_auto", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_connect_with_auto", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void onConfigButtonClick(MyBigButton button) {
        this.buttonTest = true;
        WaypointWorldRootContainer wc = this.rootContainer;
        switch (button.getId() - 200) {
            case 0: {
                wc.setUsingMultiworldDetection(!this.rootContainer.isUsingMultiworldDetection());
                wc.setDefaultMultiworldId(null);
                break;
            }
            case 1: {
                wc.setTeleportationEnabled(!wc.isTeleportationEnabled());
                break;
            }
            case 2: {
                this.rootContainer.toggleSortType();
                this.parent.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
                break;
            }
            case 3: {
                this.rootContainer.toggleSortReversed();
                this.parent.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            }
        }
        wc.saveConfig();
        button.func_238482_a_((ITextComponent)new StringTextComponent(this.getConfigButtonName(button.getId() - 200)));
    }

    public boolean func_231044_a_(double par1, double par2, int par3) {
        this.buttonTest = false;
        boolean toReturn = super.func_231044_a_(par1, par2, par3);
        if (!this.buttonTest) {
            this.goBack();
        }
        return toReturn;
    }

    protected void actionPerformed(Button p_146284_1_, int id) {
        this.buttonTest = true;
        if (p_146284_1_.field_230693_o_) {
            switch (id) {
                case 5: {
                    this.goBack();
                    break;
                }
                case 6: {
                    this.field_230706_i_.func_147108_a((Screen)new GuiTransfer(this.modMain, this.minimapSession, this.parent, this.escape));
                    break;
                }
                case 7: {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_make_automatic_msg1"), (ITextComponent)new TranslationTextComponent("gui.xaero_make_automatic_msg2")));
                    break;
                }
                case 8: {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_make_multi_automatic_msg1"), (ITextComponent)new TranslationTextComponent("gui.xaero_make_multi_automatic_msg2")));
                    break;
                }
                case 9: {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_world_msg1"), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_world_msg2")));
                    break;
                }
                case 10: {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_multi_world_msg1"), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_multi_world_msg2")));
                    break;
                }
                case 11: {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg1"), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg2")));
                    break;
                }
                case 12: {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg1"), (ITextComponent)new TranslationTextComponent("gui.xaero_divide_msg2")));
                    break;
                }
                case 13: {
                    this.field_230706_i_.func_147108_a((Screen)new GuiWorldTpCommand(this.modMain, (Screen)this, this.escape, this.waypointWorld));
                    break;
                }
                case 14: {
                    WaypointWorldContainer autoContainer = this.automaticWaypointWorld.getContainer();
                    WaypointWorldContainer selectedContainer = this.waypointWorld.getContainer();
                    String autoWorldName = autoContainer.getFullName(this.automaticWaypointWorld.getId(), autoContainer.getSubName()) + " (auto)";
                    String selectedWorldName = selectedContainer.getFullName(this.waypointWorld.getId(), selectedContainer.getSubName());
                    String connectionDisplayString = autoWorldName + "   \u00a7e<=>\u00a7r   " + selectedWorldName;
                    if (this.selectedWorldIsConnected) {
                        this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_disconnect_from_auto_msg"), (ITextComponent)new StringTextComponent(connectionDisplayString)));
                        break;
                    }
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_connect_with_auto_msg"), (ITextComponent)new StringTextComponent(connectionDisplayString)));
                }
            }
        }
    }

    public void confirmResult(boolean result, int id) {
        block30: {
            block29: {
                boolean differentRoot = this.isDifferentRootContainer();
                boolean differentSub = this.isDifferentSubWorld(differentRoot);
                boolean exitOptions = true;
                if (!result) break block29;
                switch (id) {
                    case 7: {
                        if (!differentRoot) break;
                        WaypointWorldRootContainer selected = this.rootContainer;
                        WaypointWorldRootContainer auto = (WaypointWorldRootContainer)this.waypointsManager.getWaypointMap().get(this.waypointsManager.getAutoRootContainerID());
                        if (selected == null || auto == null) break;
                        String buKey = selected.getKey();
                        this.waypointsManager.getWaypointMap().put(auto.getKey(), selected);
                        this.waypointsManager.getWaypointMap().put(buKey, auto);
                        selected.setKey(auto.getKey());
                        auto.setKey(buKey);
                        selected.updateConnectionsField(this.minimapSession);
                        auto.updateConnectionsField(this.minimapSession);
                        Path selectedPath = selected.getDirectory().toPath();
                        Path autoPath = auto.getDirectory().toPath();
                        Path tempFolder = this.modMain.getWaypointsFolder().toPath().resolve("temp_to_add");
                        try {
                            Files.createDirectories(tempFolder, new FileAttribute[0]);
                            Path selectedTemp = tempFolder.resolve(selectedPath.getFileName());
                            if (Files.exists(selectedPath, new LinkOption[0])) {
                                Files.move(selectedPath, selectedTemp, new CopyOption[0]);
                            }
                            if (Files.exists(autoPath, new LinkOption[0])) {
                                Files.move(autoPath, selectedPath, new CopyOption[0]);
                            }
                            if (Files.exists(selectedTemp, new LinkOption[0])) {
                                Files.move(selectedTemp, autoPath, new CopyOption[0]);
                            }
                            Files.deleteIfExists(tempFolder);
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                        }
                        selected.loadConfig();
                        auto.loadConfig();
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 8: {
                        if (!differentSub) break;
                        WaypointWorld autoWorld = this.automaticWaypointWorld;
                        WaypointWorld selectedWorld = this.waypointWorld;
                        try {
                            Path autoFile = this.modMain.getSettings().getWaypointsFile(autoWorld).toPath();
                            Path selectedFile = this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath();
                            Path autoTempFile = autoFile.getParent().resolve("temp_to_add").resolve(autoFile.getFileName());
                            Files.createDirectories(autoTempFile.getParent(), new FileAttribute[0]);
                            if (!Files.exists(autoFile, new LinkOption[0])) {
                                Files.createFile(autoFile, new FileAttribute[0]);
                            }
                            Files.move(autoFile, autoTempFile, new CopyOption[0]);
                            if (!Files.exists(selectedFile, new LinkOption[0])) {
                                Files.createFile(selectedFile, new FileAttribute[0]);
                            }
                            Files.move(selectedFile, autoFile, new CopyOption[0]);
                            if (Files.exists(autoTempFile, new LinkOption[0])) {
                                Files.move(autoTempFile, selectedFile, new CopyOption[0]);
                            }
                            Files.deleteIfExists(autoTempFile.getParent());
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                            break;
                        }
                        WaypointWorldContainer autoWc = autoWorld.getContainer();
                        WaypointWorldContainer selectedWc = selectedWorld.getContainer();
                        autoWorld.setContainer(selectedWc);
                        selectedWorld.setContainer(autoWc);
                        selectedWc.worlds.put(selectedWorld.getId(), autoWorld);
                        autoWc.worlds.put(autoWorld.getId(), selectedWorld);
                        String buSelected = selectedWorld.getId();
                        selectedWorld.setId(autoWorld.getId());
                        autoWorld.setId(buSelected);
                        this.rootContainer.getSubWorldConnections().swapConnections(autoWorld, selectedWorld);
                        this.rootContainer.saveConfig();
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 9: {
                        if (!differentRoot) break;
                        String selectedRootContainerId = this.rootContainer.getKey();
                        try {
                            File directory = this.modMain.getWaypointsFolder().toPath().resolve(selectedRootContainerId).toFile();
                            if (directory.exists()) {
                                FileUtils.deleteDirectory((File)directory);
                            }
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                            break;
                        }
                        this.waypointsManager.getWaypointMap().remove(selectedRootContainerId);
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 10: {
                        if (!differentSub) break;
                        WaypointWorld selectedWorld = this.waypointWorld;
                        try {
                            Files.deleteIfExists(this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath());
                        }
                        catch (IOException e) {
                            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                        }
                        selectedWorld.getContainer().worlds.remove(selectedWorld.getId());
                        selectedWorld.getContainer().removeName(selectedWorld.getId());
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 11: {
                        this.multiplyWaypoints(this.waypointWorld, 8.0);
                        break;
                    }
                    case 12: {
                        this.multiplyWaypoints(this.waypointWorld, 0.125);
                        break;
                    }
                    case 14: {
                        if (!this.selectedWorldIsConnected) {
                            this.rootContainer.getSubWorldConnections().addConnection(this.automaticWaypointWorld, this.waypointWorld);
                        } else {
                            this.rootContainer.getSubWorldConnections().removeConnection(this.automaticWaypointWorld, this.waypointWorld);
                        }
                        this.rootContainer.saveConfig();
                    }
                }
                if (exitOptions) {
                    if (this.parent instanceof GuiWaypoints) {
                        this.field_230706_i_.func_147108_a((Screen)new GuiWaypoints(this.modMain, this.minimapSession, ((GuiWaypoints)this.parent).parent, this.escape));
                    } else {
                        this.goBack();
                    }
                }
                break block30;
            }
            this.field_230706_i_.func_147108_a((Screen)this);
        }
    }

    private void multiplyWaypoints(WaypointWorld world, double factor) {
        HashMap<String, WaypointSet> sets = world.getSets();
        Iterator<WaypointSet> iter = sets.values().iterator();
        while (iter.hasNext()) {
            ArrayList<Waypoint> wpList = iter.next().getList();
            for (int i = 0; i < wpList.size(); ++i) {
                Waypoint wp = wpList.get(i);
                wp.setX((int)Math.floor((double)wp.getX() * factor));
                wp.setZ((int)Math.floor((double)wp.getZ() * factor));
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(world);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    private boolean isDifferentRootContainer() {
        return this.waypointsManager.getAutoRootContainerID() != null && !this.waypointsManager.getAutoRootContainerID().equals(this.rootContainer.getKey());
    }

    private boolean isDifferentSubWorld(boolean differentRoot) {
        return !differentRoot && this.waypointWorld != this.automaticWaypointWorld;
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.automaticButton.field_230693_o_ = this.deleteButton.field_230693_o_ = this.isDifferentRootContainer();
        this.subAutomaticButton.field_230693_o_ = this.subDeleteButton.field_230693_o_ = this.isDifferentSubWorld(this.automaticButton.field_230693_o_);
        this.parent.func_230430_a_(matrixStack, 0, 0, par3);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        this.func_230446_a_(matrixStack);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        super.func_230430_a_(matrixStack, par1, par2, par3);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.1);
        for (int k = 0; k < this.field_230710_m_.size(); ++k) {
            Widget w = (Widget)this.field_230710_m_.get(k);
            if (!(w instanceof MyBigButton)) continue;
            MyBigButton b = (MyBigButton)w;
            if (par1 < b.field_230690_l_ || par2 < b.field_230691_m_ || par1 >= b.field_230690_l_ + b.func_230998_h_() || par2 >= b.field_230691_m_ + 20) continue;
            if (b.getId() >= 200) {
                switch (b.getId() - 200) {
                    case 0: {
                        this.mwTooltip.drawBox(matrixStack, par1, par2, this.field_230708_k_, this.field_230709_l_);
                        break;
                    }
                    case 1: {
                        this.teleportationTooltip.drawBox(matrixStack, par1, par2, this.field_230708_k_, this.field_230709_l_);
                    }
                }
                continue;
            }
            if (b.getId() != 14 || !b.field_230693_o_) continue;
            this.connectionTooltip.drawBox(matrixStack, par1, par2, this.field_230708_k_, this.field_230709_l_);
        }
        matrixStack.func_227865_b_();
    }
}

