/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Team;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.category.rule.resolver.ObjectCategoryRuleResolver;
import xaero.common.effect.Effects;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadarList;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.EntityRadarCategoryManager;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private EntityRadarCategoryManager entityCategoryManager;
    private Entity lastRenderViewEntity;
    private EntityRadarCategory listsGeneratedForConfig;
    private boolean listsReversedOrder;
    private List<MinimapRadarList> radarLists;
    private Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap;

    public MinimapRadar(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, EntityRadarCategoryManager entityCategoryManager) throws IOException {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.entityCategoryManager = entityCategoryManager;
        this.radarLists = new ArrayList<MinimapRadarList>();
        this.middleRadarListMap = new HashMap<EntityRadarCategory, MinimapRadarList>();
    }

    private void ensureCategories(EntityRadarCategory rootCategory, List<MinimapRadarList> radarLists, Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap) {
        boolean reversedOrder = ModSettings.keyReverseEntityRadar.func_151470_d();
        if (this.listsGeneratedForConfig != rootCategory) {
            middleRadarListMap.clear();
            radarLists.clear();
            this.traceAddCategories(rootCategory, middleRadarListMap, radarLists);
            Collections.sort(radarLists);
            this.listsGeneratedForConfig = rootCategory;
            this.listsReversedOrder = false;
        }
        if (this.listsReversedOrder != reversedOrder) {
            Collections.reverse(radarLists);
            this.listsReversedOrder = reversedOrder;
        }
    }

    private void traceAddCategories(EntityRadarCategory category, Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap, List<MinimapRadarList> radarLists) {
        category.getDirectSubCategoryIterator().forEachRemaining(sb -> this.traceAddCategories((EntityRadarCategory)sb, middleRadarListMap, radarLists));
        MinimapRadarList radarList = MinimapRadarList.Builder.getDefault().build().setCategory(category);
        middleRadarListMap.put(category, radarList);
        radarLists.add(radarList);
    }

    public void updateRadar(ClientWorld world, PlayerEntity p, Entity renderEntity, MinimapProcessor minimap) {
        if (renderEntity == null) {
            renderEntity = this.lastRenderViewEntity;
        }
        List<MinimapRadarList> radarLists = this.radarLists;
        Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap = this.middleRadarListMap;
        EntityRadarCategoryManager entityCategoryManager = this.entityCategoryManager;
        EntityRadarCategory rootCategory = entityCategoryManager.getRootCategory();
        this.ensureCategories(rootCategory, radarLists, middleRadarListMap);
        radarLists.forEach(l -> l.getEntities().clear());
        if (!this.modMain.getSettings().getEntityRadar() || world == null || p == null || renderEntity == null || p.func_70644_a(Effects.NO_RADAR) || p.func_70644_a(Effects.NO_RADAR_BENEFICIAL) || p.func_70644_a(Effects.NO_RADAR_HARMFUL)) {
            return;
        }
        ObjectCategoryRuleResolver categoryRuleResolver = entityCategoryManager.getRuleResolver();
        Iterable worldEntities = world.func_217416_b();
        int cullingSize = minimap.getMinimapSize() / 2 + 48;
        double maxDistance = (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
        for (Entity e : worldEntities) {
            try {
                int heightLimit;
                double offh;
                double offheight2;
                EntityRadarCategory entityCategory;
                double offy;
                double offy2;
                double offx = e.func_226277_ct_() - renderEntity.func_226277_ct_();
                double offx2 = offx * offx;
                if (offx2 > maxDistance || (offy2 = (offy = e.func_226281_cx_() - renderEntity.func_226281_cx_()) * offy) > maxDistance || (entityCategory = categoryRuleResolver.resolve(rootCategory, e, p)) == null || !entityCategory.getSettingValue(EntityRadarCategorySettings.DISPLAYED).booleanValue() || (offheight2 = (offh = renderEntity.func_226278_cu_() - e.func_226278_cu_()) * offh) > (double)((heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue()) * heightLimit)) continue;
                List<Entity> typeList = middleRadarListMap.get(entityCategory).getEntities();
                int entityAmount = entityCategory.getSettingValue(EntityRadarCategorySettings.ENTITY_NUMBER).intValue();
                if (entityAmount != 0 && typeList.size() >= entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    public double getEntityX(Entity e, float partial) {
        return e.field_70142_S + (e.func_226277_ct_() - e.field_70142_S) * (double)partial;
    }

    public double getEntityY(Entity e, float partial) {
        return e.field_70137_T + (e.func_226278_cu_() - e.field_70137_T) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        return e.field_70136_U + (e.func_226281_cx_() - e.field_70136_U) * (double)partial;
    }

    public boolean shouldRenderEntity(Entity e, Entity renderEntity) {
        return e == renderEntity || !e.func_225608_bj_() && !e.func_82150_aj();
    }

    public int getTeamColour(Entity e) {
        Integer teamColour = null;
        Team team = e.func_96124_cp();
        if (team != null) {
            teamColour = team.func_178775_l().func_211163_e();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(PlayerEntity p, Entity e, float offh, boolean cave, EntityRadarCategory category, int heightLimit, int startFadingAt, boolean heightBasedFade, int colorIndex) {
        float brightness;
        int color = -1;
        if (colorIndex == -1) {
            int entityTeamColour = this.getTeamColour(e);
            if (entityTeamColour != -1) {
                color = 0xFF000000 | entityTeamColour;
            } else {
                EntityRadarCategory fallbackCategory = category;
                while (colorIndex == -1) {
                    if ((fallbackCategory = (EntityRadarCategory)fallbackCategory.getSuperCategory()) == null) {
                        colorIndex = 15;
                        continue;
                    }
                    colorIndex = fallbackCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue();
                }
            }
        }
        if (colorIndex != -1) {
            color = ModSettings.COLORS[colorIndex];
        }
        if ((brightness = this.getEntityBrightness(offh, heightLimit, startFadingAt, heightBasedFade)) < 1.0f) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = 255;
            if (cave) {
                a = (int)((float)a * brightness);
            } else {
                r = (int)((float)r * brightness);
                g = (int)((float)g * brightness);
                b = (int)((float)b * brightness);
            }
            color = a << 24 | r << 16 | g << 8 | b;
        }
        return color;
    }

    public float getEntityBrightness(float offh, int heightLimit, int startFadingAt, boolean heightBasedFade) {
        int threshold;
        float level = (float)heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        int n = threshold = startFadingAt == 0 ? heightLimit * 3 / 4 : heightLimit - startFadingAt;
        if (level <= (float)threshold && heightBasedFade) {
            brightness = 0.25f + 0.5f * level / (float)threshold;
        }
        return brightness;
    }

    public void setLastRenderViewEntity(Entity lastRenderViewEntity) {
        this.lastRenderViewEntity = lastRenderViewEntity;
    }

    public EntityRadarCategoryManager getEntityCategoryManager() {
        return this.entityCategoryManager;
    }

    public Iterator<MinimapRadarList> getRadarListsIterator() {
        return this.radarLists.iterator();
    }
}

