/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Difficulty;
import xaero.common.MinimapLogs;

public class RadarUtils {
    public static DataParameter<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    public static DataParameter<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;

    public static boolean hostileException(Entity e) {
        if (e instanceof PiglinEntity) {
            return ((PiglinEntity)e).func_70631_g_();
        }
        return false;
    }

    public static boolean isTamed(Entity e, PlayerEntity p) {
        if (e instanceof TameableEntity) {
            TameableEntity tameable = (TameableEntity)e;
            if (tameable.func_70909_n() && p.func_110124_au().equals(tameable.func_184753_b())) {
                return true;
            }
        } else if (e instanceof AbstractHorseEntity) {
            AbstractHorseEntity horse = (AbstractHorseEntity)e;
            if (horse.func_110248_bS() && p.func_110124_au().equals(horse.func_184780_dh())) {
                return true;
            }
        } else if (e instanceof FoxEntity) {
            FoxEntity fox = (FoxEntity)e;
            if (FOX_TRUSTED_UUID_SECONDARY != null && p.func_110124_au().equals(((Optional)fox.func_184212_Q().func_187225_a(FOX_TRUSTED_UUID_SECONDARY)).orElse(null))) {
                return true;
            }
            if (FOX_TRUSTED_UUID_MAIN != null && p.func_110124_au().equals(((Optional)fox.func_184212_Q().func_187225_a(FOX_TRUSTED_UUID_MAIN)).orElse(null))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isHostile(Entity e) {
        return Minecraft.func_71410_x().field_71441_e.func_175659_aa() != Difficulty.PEACEFUL && !RadarUtils.hostileException(e) && (e instanceof MonsterEntity || e instanceof IMob || e.func_184176_by() == SoundCategory.HOSTILE);
    }

    static {
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = FoxEntity.class.getDeclaredField("field_213509_bB");
        }
        catch (Exception e) {
            try {
                foxTrustSecondaryField = FoxEntity.class.getDeclaredField("DATA_TRUSTED_ID_0");
            }
            catch (Exception e1) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e1);
            }
        }
        try {
            foxTrustMainField = FoxEntity.class.getDeclaredField("field_213510_bD");
        }
        catch (Exception e) {
            try {
                foxTrustMainField = FoxEntity.class.getDeclaredField("DATA_TRUSTED_ID_1");
            }
            catch (Exception e1) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e1);
            }
        }
        if (foxTrustSecondaryField != null) {
            try {
                boolean accessibleBU = foxTrustSecondaryField.isAccessible();
                foxTrustSecondaryField.setAccessible(true);
                FOX_TRUSTED_UUID_SECONDARY = (DataParameter)foxTrustSecondaryField.get(null);
                foxTrustSecondaryField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        if (foxTrustMainField != null) {
            try {
                boolean accessibleBU = foxTrustMainField.isAccessible();
                foxTrustMainField.setAccessible(true);
                FOX_TRUSTED_UUID_MAIN = (DataParameter)foxTrustMainField.get(null);
                foxTrustMainField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }
}

