/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsGuiRenderer {
    private IXaeroMinimap modMain;
    private Minecraft mc;
    private List<Waypoint> sortingList;
    private WaypointFilterParams filterParams;
    private Predicate<Waypoint> filter;
    private final WaypointDeleter waypointReachDeleter;

    public WaypointsGuiRenderer(IXaeroMinimap modMain, WaypointDeleter waypointReachDeleter, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
        this.sortingList = new ArrayList<Waypoint>();
        this.filterParams = new WaypointFilterParams();
        this.filter = w -> {
            WaypointFilterParams filterParams = this.filterParams;
            boolean deathpoints = filterParams.deathpoints;
            if (w.isDisabled() || (w.getWaypointType() == 1 || w.getWaypointType() == 2) && !deathpoints) {
                return false;
            }
            double offx = (double)w.getX(filterParams.dimDiv) + 0.5 - filterParams.cameraX;
            double offz = (double)w.getZ(filterParams.dimDiv) + 0.5 - filterParams.cameraZ;
            double distance = Math.sqrt(offx * offx + offz * offz);
            double waypointsDistance = filterParams.waypointsDistance;
            return w.isOneoffDestination() || w.getWaypointType() == 1 || w.isGlobal() || waypointsDistance == 0.0 || !(distance > waypointsDistance);
        };
        this.waypointReachDeleter = waypointReachDeleter;
    }

    public void render(XaeroMinimapSession minimapSession, MatrixStack matrixStack, MinimapRendererHelper rendererHelper, double playerX, double playerY, double playerZ, int specW, int specH, double ps, double pc, float partial, double zoom, boolean circle, float minimapScale, IRenderTypeBuffer.Impl renderTypeBuffer, boolean safeMode) {
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        IVertexBuilder waypointBackgroundConsumer = renderTypeBuffer.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        Waypoint.RENDER_SORTING_POS = this.mc.field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, -980.0);
        if (this.modMain.getSettings().compassOverWaypoints) {
            this.drawWaypoints(waypointsManager, matrixStack, rendererHelper, playerX, playerY, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale, renderTypeBuffer, waypointBackgroundConsumer);
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(matrixStack, rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false, renderTypeBuffer, null);
            }
        } else {
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(matrixStack, rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false, renderTypeBuffer, null);
            }
            this.drawWaypoints(waypointsManager, matrixStack, rendererHelper, playerX, playerY, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale, renderTypeBuffer, waypointBackgroundConsumer);
        }
        matrixStack.func_227865_b_();
        renderTypeBuffer.func_228461_a_();
    }

    private void drawWaypoints(WaypointsManager waypointsManager, MatrixStack matrixStack, MinimapRendererHelper rendererHelper, double playerX, double playerY, double playerZ, int specW, int specH, double ps, double pc, float partial, double dimDiv, double zoom, boolean circle, float minimapScale, IRenderTypeBuffer.Impl textRenderTypeBuffer, IVertexBuilder waypointBackgroundConsumer) {
        if (this.mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || this.mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) || this.mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL)) {
            return;
        }
        List<Waypoint> sortingList = this.sortingList;
        sortingList.clear();
        if (this.modMain.getSettings().getShowWaypoints() && waypointsManager.getWaypoints() != null) {
            if (this.modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    sortingList.addAll(setEntry.getValue().getList());
                }
            } else {
                sortingList.addAll(waypointsManager.getWaypoints().getList());
            }
        }
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = WaypointsManager.customWaypoints;
        if (this.modMain.getSettings().getShowWaypoints() && !customWaypoints.isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                sortingList.addAll(modCustomWaypoints.values());
            }
        }
        boolean deleteReachedDeathpoints = this.modMain.getSettings().deleteReachedDeathpoints;
        if (!sortingList.isEmpty()) {
            this.waypointReachDeleter.begin();
            this.filterParams.setParams(playerX, 0.0, playerZ, null, dimDiv, this.modMain.getSettings().getDeathpoints(), this.modMain.getSettings().getMaxWaypointsDistance(), this.modMain.getSettings().waypointsDistanceMin, 0.0);
            Iterator<Waypoint> iterator = sortingList.stream().filter(this.filter).sorted().iterator();
            this.renderWaypointsIterator(matrixStack, rendererHelper, iterator, playerX, playerY, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale, textRenderTypeBuffer, waypointBackgroundConsumer, deleteReachedDeathpoints);
            this.waypointReachDeleter.deleteCollected(waypointsManager.getCurrentWorld(), this.modMain.getSettings().renderAllSets);
        }
    }

    private void renderWaypointsIterator(MatrixStack matrixStack, MinimapRendererHelper rendererHelper, Iterator<Waypoint> iter, double playerX, double playerY, double playerZ, int specW, int specH, double ps, double pc, double dimDiv, double zoom, boolean circle, float minimapScale, IRenderTypeBuffer.Impl textRenderTypeBuffer, IVertexBuilder waypointBackgroundConsumer, boolean deleteReachedDeathpoints) {
        while (iter.hasNext()) {
            Waypoint w = iter.next();
            int wX = w.getX(dimDiv);
            int wZ = w.getZ(dimDiv);
            double offx = (double)wX + 0.5 - playerX;
            double offz = (double)wZ + 0.5 - playerZ;
            if (deleteReachedDeathpoints && w.isOneoffDestination() && System.currentTimeMillis() - w.getCreatedAt() > 5000L) {
                double correctOffZ;
                double correctDistance;
                double correctOffX = playerX - (double)wX - 0.5;
                double correctOffY = playerY - (double)w.getY();
                if (!w.isYIncluded()) {
                    correctOffY = 0.0;
                }
                if ((correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + (correctOffZ = playerZ - (double)wZ - 0.5) * correctOffZ)) < 4.0) {
                    this.waypointReachDeleter.add(w);
                }
            }
            matrixStack.func_227861_a_(0.0, 0.0, 0.1);
            this.translatePosition(matrixStack, specW, specH, ps, pc, offx, offz, zoom, circle);
            matrixStack.func_227862_a_(minimapScale, minimapScale, 1.0f);
            this.drawIconOnGUI(matrixStack, rendererHelper, w, this.modMain.getSettings(), 0, 0, textRenderTypeBuffer, waypointBackgroundConsumer);
            matrixStack.func_227865_b_();
        }
    }

    public void drawCompass(MatrixStack matrixStack, MinimapRendererHelper rendererHelper, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background, IRenderTypeBuffer.Impl textRenderTypeBuffer, IVertexBuilder nameBgBuilder) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        String[] nesw = new String[]{I18n.func_135052_a((String)"gui.xaero_compass_north", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_east", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_south", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_west", (Object[])new Object[0])};
        int defaultColor = ModSettings.COLORS[this.modMain.getSettings().compassColor];
        GlStateManager.func_227621_I_();
        for (int i = 0; i < 4; ++i) {
            int effectiveColor;
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            matrixStack.func_227861_a_(0.0, 0.0, 2.0);
            this.translatePosition(matrixStack, specW, specH, ps, pc, offx, offy, zoom, circle);
            matrixStack.func_227862_a_(minimapScale, minimapScale, 1.0f);
            int halfW = this.mc.field_71466_p.func_78256_a(nesw[i]) / 2 - 1;
            int n = effectiveColor = i == 0 ? ModSettings.COLORS[this.modMain.getSettings().getNorthCompassColor()] : defaultColor;
            if (background) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                rendererHelper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), nameBgBuilder, -4 - addedFrame, -4 - addedFrame, 9 + 2 * addedFrame, 9 + 2 * addedFrame, 0x90000000 | effectiveColor & 0xFFFFFF);
                RenderSystem.defaultBlendFunc();
            }
            Misc.drawNormalText(matrixStack, nesw[i], -halfW + 1, -2.0f, effectiveColor, false, textRenderTypeBuffer);
            matrixStack.func_227861_a_(0.0, 0.0, 1.0);
            Misc.drawNormalText(matrixStack, nesw[i], -halfW, -3.0f, -1, false, textRenderTypeBuffer);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227861_a_(0.0, 0.0, 2.0);
    }

    public void translatePosition(MatrixStack matrixStack, int specW, int specH, double ps, double pc, double offx, double offy, double zoom, boolean circle) {
        double X;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(Math.round(borderedX) - 1L), (double)(Math.round(borderedY) - 1L), 0.0);
    }

    public void drawIconOnGUI(MatrixStack matrixStack, MinimapRendererHelper rendererHelper, Waypoint w, ModSettings settings, int drawX, int drawY, IRenderTypeBuffer.Impl renderTypeBuffer, IVertexBuilder waypointBackgroundConsumer) {
        int c = ModSettings.COLORS[w.getColor()];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        int j = w.getWaypointType() == 1 ? 4 : Minecraft.func_71410_x().field_71466_p.func_78256_a(w.getSymbol()) / 2;
        int addedFrame = j > 4 ? j - 4 : 0;
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4 - addedFrame;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5 + addedFrame;
        rendererHelper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), waypointBackgroundConsumer, rectX1, rectY1, rectX2 - rectX1, rectY2 - rectY1, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        matrixStack.func_227861_a_(0.0, 0.0, 0.05);
        if (w.getWaypointType() != 1) {
            Misc.drawNormalText(matrixStack, w.getSymbol(), drawX + 1 - j, drawY - 3, -1, true, renderTypeBuffer);
        } else {
            RenderSystem.enableDepthTest();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            RenderSystem.color4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_238474_b_(matrixStack, rectX1 + 1, rectY1 + 1, 0, 78, 9, 9);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_238474_b_(matrixStack, rectX1, rectY1, 0, 78, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, MatrixStack matrixStack, MainWindow res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                IRenderTypeBuffer.Impl textRenderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
                Misc.drawCenteredPiercingText(matrixStack, I18n.func_135052_a((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), (float)(res.func_198107_o() / 2), (float)(res.func_198087_p() / 2 + 50), c, true, textRenderTypeBuffers);
                textRenderTypeBuffers.func_228461_a_();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }
}

