/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import net.minecraft.util.text.Color;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Color.class})
public class ColorMixin {
    @Inject(method={"parseColor"}, at={@At(value="HEAD")}, cancellable=true)
    private static boolean parseColor(String colorString, CallbackInfoReturnable<Color> info) {
        if (!colorString.startsWith("#")) {
            return false;
        }
        try {
            int i = Integer.parseUnsignedInt(colorString.substring(1), 16);
            info.setReturnValue((Object)Color.func_240743_a_((int)i));
            return true;
        }
        catch (NumberFormatException numberformatexception) {
            info.setReturnValue(null);
            return true;
        }
    }
}

